/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.bytebuddy.AbstractJunction;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.IndirectMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class PluginFinder {
    private final Map<String, List<AbstractClassEnhancePluginDefine>> nameMatchDefine = new HashMap<String, List<AbstractClassEnhancePluginDefine>>();
    private final List<AbstractClassEnhancePluginDefine> signatureMatchDefine = new LinkedList<AbstractClassEnhancePluginDefine>();

    public PluginFinder(List<AbstractClassEnhancePluginDefine> plugins) {
        for (AbstractClassEnhancePluginDefine plugin : plugins) {
            ClassMatch match = plugin.enhanceClass();
            if (match == null) continue;
            if (match instanceof NameMatch) {
                NameMatch nameMatch = (NameMatch)match;
                List<AbstractClassEnhancePluginDefine> list = this.nameMatchDefine.get(nameMatch.getClassName());
                if (list == null) {
                    list = new ArrayList<AbstractClassEnhancePluginDefine>();
                    this.nameMatchDefine.put(nameMatch.getClassName(), list);
                }
                list.add(plugin);
                continue;
            }
            this.signatureMatchDefine.add(plugin);
        }
    }

    public List<AbstractClassEnhancePluginDefine> find(TypeDescription typeDescription, ClassLoader classLoader) {
        ArrayList<AbstractClassEnhancePluginDefine> list = new ArrayList<AbstractClassEnhancePluginDefine>();
        String typeName = typeDescription.getTypeName();
        if (this.nameMatchDefine.containsKey(typeName)) {
            list.addAll((Collection)this.nameMatchDefine.get(typeName));
        }
        for (AbstractClassEnhancePluginDefine pluginDefine : this.signatureMatchDefine) {
            IndirectMatch match = (IndirectMatch)pluginDefine.enhanceClass();
            if (!match.isMatch(typeDescription)) continue;
            list.add(pluginDefine);
        }
        return list;
    }

    public ElementMatcher buildMatch() {
        AbstractJunction<NamedElement> judge = new AbstractJunction<NamedElement>(){

            public boolean matches(NamedElement target) {
                return PluginFinder.this.nameMatchDefine.containsKey(target.getActualName());
            }
        };
        judge = judge.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
        for (AbstractClassEnhancePluginDefine define : this.signatureMatchDefine) {
            ClassMatch match = define.enhanceClass();
            if (!(match instanceof IndirectMatch)) continue;
            judge = judge.or((ElementMatcher)((IndirectMatch)match).buildJunction());
        }
        return judge;
    }
}

