/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.ElasticjobMonitorManager;
import cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob.ElasticjobMonitorMvcEndpoint;
import io.elasticjob.lite.api.JobScheduler;
import io.elasticjob.lite.config.LiteJobConfiguration;
import io.elasticjob.lite.internal.config.LiteJobConfigurationGsonFactory;
import io.elasticjob.lite.internal.schedule.JobRegistry;
import io.elasticjob.lite.internal.storage.JobNodePath;
import io.elasticjob.lite.reg.zookeeper.ZookeeperConfiguration;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={JobScheduler.class})
public class ElasticjobMonitorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticjobMonitorAutoConfiguration.class);
    @Autowired
    private ElasticjobMonitorManager elasticjobMonitorManager;

    @EventListener(value={MainContextRefreshedEvent.class})
    public void init() {
        JobRegistry jobRegistry = JobRegistry.getInstance();
        if (jobRegistry == null) {
            return;
        }
        try {
            Field regCenterMapField = ReflectionUtils.findField(JobRegistry.class, (String)"regCenterMap");
            ReflectionUtils.makeAccessible((Field)regCenterMapField);
            Map centerMap = (Map)ReflectionUtils.getField((Field)regCenterMapField, (Object)jobRegistry);
            if (centerMap == null || centerMap.size() == 0) {
                return;
            }
            boolean isSetJobName = false;
            for (Map.Entry entry : centerMap.entrySet()) {
                ZookeeperRegistryCenter center = (ZookeeperRegistryCenter)entry.getValue();
                if (!isSetJobName) {
                    Field zkConfigField = ReflectionUtils.findField(ZookeeperRegistryCenter.class, (String)"zkConfig");
                    ReflectionUtils.makeAccessible((Field)zkConfigField);
                    ZookeeperConfiguration configuration = (ZookeeperConfiguration)ReflectionUtils.getField((Field)zkConfigField, (Object)center);
                    this.elasticjobMonitorManager.setJobNamespace(configuration.getNamespace());
                    isSetJobName = true;
                }
                String jobName = (String)entry.getKey();
                JobNodePath jobNodePath = new JobNodePath(jobName);
                String json = center.getDirectly(jobNodePath.getConfigNodePath());
                LiteJobConfiguration liteJobConfiguration = LiteJobConfigurationGsonFactory.fromJson((String)json);
                this.elasticjobMonitorManager.putJobCronMap(jobName, liteJobConfiguration.getTypeConfig().getCoreConfig().getCron());
            }
        }
        catch (Exception e) {
            log.info("\u521d\u59cb\u5316\u4f5c\u4e1a\u7684\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
        boolean isPresent = ClassUtils.isPresent((String)"io.elasticjob.autoconfigure.eventbus.JobEventCacheStorage", null);
        if (!isPresent) {
            log.warn("\u672a\u53d1\u73b0JobEventCacheStorage\u5b9e\u4f8b\uff0c\u8bf7\u53bb\u9664elastic-job-spring-boot-starter\u7684\u7248\u672c\u53f7\u6307\u5b9a\uff0c\u7531ext\u6765\u7ba1\u7406\u7248\u672c\uff0c\u5426\u5219\u65e0\u6cd5\u76d1\u63a7job\u7684\u5386\u53f2\u8f68\u8ff9\u548c\u5f02\u5e38\u62a5\u8b66");
        }
    }

    @Configuration
    public static class ElasticjobMonitorManagerConfiguration {
        @Bean
        public ElasticjobMonitorManager elasticjobMonitorManagerConfiguration() {
            return new ElasticjobMonitorManager();
        }
    }

    @Configuration
    public static class ElasticjobMonitorEndpointConfiguration {
        @Bean
        public ElasticjobMonitorMvcEndpoint elasticjobMonitorEndpointConfiguration() {
            return new ElasticjobMonitorMvcEndpoint();
        }
    }
}

