/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import ch.qos.logback.classic.Level;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaInstanceChangedEvent;
import cn.com.duibaboot.ext.autoconfigure.core.EarlyClose;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.RocketMqProperties;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.util.ReflectionUtils;

public class DefaultMQPushConsumerWrapper
extends EarlyClose {
    private static final Logger log = LoggerFactory.getLogger(DefaultMQPushConsumerWrapper.class);
    @Resource
    private ApplicationContext applicationContext;
    private DefaultMQPushConsumer rocketMqConsumer;
    private RocketMqProperties rocketMqProperties;
    private RocketMqProperties.ConsumerProperties consumerProperties;
    private String messageListenerBeanId;
    private boolean started = false;
    private String currentAppName;
    @Value(value="${server.port}")
    private int serverPort;
    @Resource
    private EurekaClient eurekaClient;

    @Value(value="${spring.application.name}")
    public void setCurrentAppName(String currentAppName) {
        this.currentAppName = currentAppName.toUpperCase();
    }

    public DefaultMQPushConsumerWrapper(RocketMqProperties rocketMqProperties, int consumerPropertiesIndex) {
        this.rocketMqProperties = rocketMqProperties;
        if (consumerPropertiesIndex == -1) {
            this.consumerProperties = rocketMqProperties.getConsumer();
            this.messageListenerBeanId = "bootRocketMqMessageListener";
        } else {
            this.consumerProperties = rocketMqProperties.getExtraConsumer()[consumerPropertiesIndex];
            this.messageListenerBeanId = "extraBootRocketMqMessageListener" + consumerPropertiesIndex;
        }
    }

    public synchronized void startRun() throws MQClientException {
        String[] topicArr;
        MessageListener rocketMqMessageListener;
        if (this.started) {
            log.warn("rocketmq consumer have already started, please don't call start again");
            return;
        }
        try {
            rocketMqMessageListener = (MessageListener)this.applicationContext.getBean(this.messageListenerBeanId, MessageListener.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error("", (Throwable)new IllegalStateException("bean id:[" + this.messageListenerBeanId + "] class:[org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context, \u8bf7\u58f0\u660e\uff0c\u5426\u5219\u4e0d\u4f1a\u542f\u7528rocketmq\u6d88\u8d39!!!\uff0c\u8bf7\u53c2\u8003: http://gitlab2.dui88.com/basic_platform/spring-boot-ext/wikis/Starter%E7%89%B9%E6%80%A7/_rocketmq%E3%80%90%E5%BC%80%E6%BA%90RocketMQ%E3%80%91"));
            return;
        }
        DefaultMQPushConsumer consumer = new DefaultMQPushConsumer(this.consumerProperties.getGroup());
        consumer.setNamesrvAddr(this.rocketMqProperties.getNameSrvAddr());
        consumer.setMaxReconsumeTimes(this.consumerProperties.getMaxReconsumeTimes().intValue());
        if (this.consumerProperties.getConsumeThreadNums() > 0) {
            consumer.setConsumeThreadMin(this.consumerProperties.getConsumeThreadNums().intValue());
            consumer.setConsumeThreadMax(Math.max(this.consumerProperties.getConsumeThreadNums(), 64));
        }
        consumer.setMessageModel(this.consumerProperties.getMessageModelEnum());
        consumer.setConsumeMessageBatchMaxSize(this.consumerProperties.getConsumeMessageBatchMaxSize().intValue());
        String topics = this.consumerProperties.getTopics();
        for (String topic : topicArr = topics.split(",")) {
            consumer.subscribe(topic, "*");
        }
        if (rocketMqMessageListener instanceof MessageListenerConcurrently) {
            consumer.registerMessageListener((MessageListenerConcurrently)rocketMqMessageListener);
        } else if (rocketMqMessageListener instanceof MessageListenerOrderly) {
            consumer.registerMessageListener((MessageListenerOrderly)rocketMqMessageListener);
        }
        this.rocketMqConsumer = consumer;
        this.rocketMqConsumer.start();
        this.started = true;
    }

    public synchronized void shutdown() {
        if (!this.started) {
            return;
        }
        this.rocketMqConsumer.shutdown();
        if (this.rocketMqConsumer != null) {
            this.rocketMqConsumer.shutdown();
            this.awaitShutdown(this.rocketMqConsumer, 3);
        }
        this.started = false;
    }

    private void awaitShutdown(DefaultMQPushConsumer defaultMQPushConsumer, int awaitMaxSeconds) {
        Field fieldDefaultMQPushConsumerImpl = ReflectionUtils.findField(defaultMQPushConsumer.getClass(), (String)"defaultMQPushConsumerImpl");
        fieldDefaultMQPushConsumerImpl.setAccessible(true);
        Object defaultMQPushConsumerImpl = ReflectionUtils.getField((Field)fieldDefaultMQPushConsumerImpl, (Object)defaultMQPushConsumer);
        Field fieldConsumeMessageService = ReflectionUtils.findField(defaultMQPushConsumerImpl.getClass(), (String)"consumeMessageService");
        fieldConsumeMessageService.setAccessible(true);
        Object consumeMessageService = ReflectionUtils.getField((Field)fieldConsumeMessageService, (Object)defaultMQPushConsumerImpl);
        Field fieldConsumeExecutor = ReflectionUtils.findField(consumeMessageService.getClass(), (String)"consumeExecutor");
        fieldConsumeExecutor.setAccessible(true);
        ThreadPoolExecutor consumeExecutor = (ThreadPoolExecutor)ReflectionUtils.getField((Field)fieldConsumeExecutor, (Object)consumeMessageService);
        try {
            consumeExecutor.awaitTermination(awaitMaxSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    synchronized boolean isStarted() {
        return this.started;
    }

    @EventListener(value={EurekaInstanceChangedEvent.class})
    public void onEurekaInstanceChanged(EurekaInstanceChangedEvent event) throws MQClientException {
        InstanceInfo.InstanceStatus currentInstanceStatus = null;
        String weight = null;
        if (event.getAppNames().contains(this.currentAppName)) {
            List instances = this.eurekaClient.getApplication(this.currentAppName).getInstancesAsIsFromEureka();
            for (InstanceInfo info : instances) {
                if (!NetUtils.getLocalIp().equals(info.getIPAddr()) || this.serverPort != info.getPort()) continue;
                currentInstanceStatus = info.getStatus();
                weight = info.getMetadata().getOrDefault("weight", "100");
            }
        }
        if ((currentInstanceStatus == InstanceInfo.InstanceStatus.OUT_OF_SERVICE || "0".equals(weight)) && this.isStarted()) {
            log.info("\u68c0\u6d4b\u5230\u5f53\u524d\u5b9e\u4f8b\u88ab\u7981\u7528(\u6216\u6743\u91cd\u8c03\u4e3a0), \u505c\u6b62\u672c\u5b9e\u4f8b\u7684rocketmq\u6d88\u8d39");
            this.shutdown();
        } else if (currentInstanceStatus == InstanceInfo.InstanceStatus.UP && !"0".equals(weight) && !this.isStarted()) {
            log.info("\u68c0\u6d4b\u5230\u5f53\u524d\u5b9e\u4f8b\u88ab\u91cd\u65b0\u542f\u7528\u4e14\u6743\u91cd\u5927\u4e8e0, \u91cd\u65b0\u5f00\u59cb\u672c\u5b9e\u4f8b\u7684rocketmq\u6d88\u8d39");
            this.startRun();
        }
    }

    public void stop() {
        this.shutdown();
    }

    public int getPhase() {
        return 1;
    }

    static {
        ((ch.qos.logback.classic.Logger)log).setLevel(Level.INFO);
    }
}

