/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.util.StringUtils;

@Activate(group={"provider", "consumer"}, order=-9000)
public class SleuthDubboFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SleuthDubboFilter.class);
    private static final boolean HAS_TRACER_CLASS;
    private static volatile Tracer tracer;
    private static volatile ErrorParser errorParser;
    private static volatile SpanReporter spanReporter;
    private static volatile HttpSpanInjector httpSpanInjector;
    private static volatile HttpSpanExtractor httpSpanExtractor;

    private static Tracer getTracer() {
        if (tracer == null && MainApplicationContextHolder.getApplicationContext() != null) {
            tracer = (Tracer)MainApplicationContextHolder.getApplicationContext().getBean(Tracer.class);
        }
        return tracer;
    }

    private static ErrorParser getErrorParser() {
        if (errorParser == null && MainApplicationContextHolder.getApplicationContext() != null) {
            errorParser = (ErrorParser)MainApplicationContextHolder.getApplicationContext().getBean(ErrorParser.class);
        }
        return errorParser;
    }

    private static SpanReporter getSpanReporter() {
        if (spanReporter == null && MainApplicationContextHolder.getApplicationContext() != null) {
            spanReporter = (SpanReporter)MainApplicationContextHolder.getApplicationContext().getBean(SpanReporter.class);
        }
        return spanReporter;
    }

    private static HttpSpanInjector getHttpSpanInjector() {
        if (httpSpanInjector == null && MainApplicationContextHolder.getApplicationContext() != null) {
            httpSpanInjector = (HttpSpanInjector)MainApplicationContextHolder.getApplicationContext().getBean(HttpSpanInjector.class);
        }
        return httpSpanInjector;
    }

    private static HttpSpanExtractor getHttpSpanExtractor() {
        if (httpSpanExtractor == null && MainApplicationContextHolder.getApplicationContext() != null) {
            httpSpanExtractor = (HttpSpanExtractor)MainApplicationContextHolder.getApplicationContext().getBean(HttpSpanExtractor.class);
        }
        return httpSpanExtractor;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (!HAS_TRACER_CLASS) {
            return invoker.invoke(invocation);
        }
        if (SleuthDubboFilter.getTracer() == null) {
            return invoker.invoke(invocation);
        }
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        String spanName = "dubbo:/" + invoker.getInterface().getSimpleName() + "/" + invocation.getMethodName();
        if ("consumer".equals(sideKey)) {
            Span span = SleuthDubboFilter.getTracer().createSpan(spanName);
            try {
                span.tag("lc", "dubbo");
                span.tag("peer.host", RpcContext.getContext().getRemoteHost() + ":" + RpcContext.getContext().getRemotePort());
                SleuthDubboFilter.getHttpSpanInjector().inject(span, (Object)new DubboClientRequestTextMap(RpcContext.getContext()));
                span.tag("dubbo.invokeMethod", invoker.getInterface().getSimpleName() + "." + invocation.getMethodName());
                span.logEvent("cs");
                Result result = invoker.invoke(invocation);
                if (result.hasException()) {
                    SleuthDubboFilter.getErrorParser().parseErrorTags(span, result.getException());
                }
                Result result2 = result;
                return result2;
            }
            catch (Exception e) {
                SleuthDubboFilter.getErrorParser().parseErrorTags(span, (Throwable)e);
                throw e;
            }
            finally {
                span.logEvent("cr");
                SleuthDubboFilter.getTracer().close(span);
            }
        }
        Span span = SleuthDubboFilter.getHttpSpanExtractor().joinTrace((Object)new DubboServerRequestTextMap(RpcContext.getContext()));
        if (span != null) {
            SleuthDubboFilter.getTracer().continueSpan(span);
        } else {
            span = SleuthDubboFilter.getTracer().createSpan(spanName);
        }
        try {
            span.tag("lc", "dubbo");
            span.logEvent("sr");
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                SleuthDubboFilter.getErrorParser().parseErrorTags(span, result.getException());
            }
            Result result3 = result;
            return result3;
        }
        catch (Exception e) {
            SleuthDubboFilter.getErrorParser().parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("ss");
            this.recordParentSpan(span);
            SleuthDubboFilter.getTracer().close(span);
        }
    }

    private void recordParentSpan(Span parent) {
        if (parent == null) {
            return;
        }
        if (parent.isRemote()) {
            if (log.isDebugEnabled()) {
                log.debug("Trying to send the parent span " + parent + " to Zipkin");
            }
            parent.stop();
            SleuthDubboFilter.getSpanReporter().report(parent);
        }
    }

    static {
        boolean hasTracerClass = true;
        try {
            Class.forName("org.springframework.cloud.sleuth.Tracer");
        }
        catch (ClassNotFoundException e) {
            hasTracerClass = false;
        }
        HAS_TRACER_CLASS = hasTracerClass;
    }

    static class DubboServerRequestTextMap
    implements SpanTextMap {
        private final RpcContext delegate;

        DubboServerRequestTextMap(RpcContext delegate) {
            this.delegate = delegate;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(this.delegate.getAttachments());
            map.put("X-Span-Uri", "/undefined");
            return map.entrySet().iterator();
        }

        public void put(String key, String value) {
            if (!StringUtils.hasText((String)value)) {
                return;
            }
            this.delegate.setAttachment(key, value);
        }
    }

    static class DubboClientRequestTextMap
    implements SpanTextMap {
        private final RpcContext delegate;

        DubboClientRequestTextMap(RpcContext delegate) {
            this.delegate = delegate;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            HashMap map = new HashMap();
            return map.entrySet().iterator();
        }

        public void put(String key, String value) {
            if (!StringUtils.hasText((String)value)) {
                return;
            }
            this.delegate.setAttachment(key, value);
        }
    }
}

