/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop.IgnoreSubInvokesContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.RedisFlowReplaySpan;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RecordRedisTemplatePlugin {
    private static final Logger log = LoggerFactory.getLogger(RecordRedisTemplatePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* org.springframework.data.redis.core.RedisTemplate.*(..))")
    public Object redisTemplateJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Object ret;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (!"executePipelined".equals(method.getName())) {
            return joinPoint.proceed();
        }
        if (!FlowReplayTrace.isTraced()) {
            return joinPoint.proceed();
        }
        if (IgnoreSubInvokesContext.isMarked()) {
            return joinPoint.proceed();
        }
        Object[] parameterValues = joinPoint.getArgs();
        Object obj = joinPoint.getTarget();
        IgnoreSubInvokesContext.instMark(obj, method.getName(), parameterValues);
        try {
            ret = joinPoint.proceed();
        }
        catch (Throwable t) {
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }
        try {
            RedisFlowReplaySpan span = RedisFlowReplaySpan.createSpan(method, null, null, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
        }
        catch (Throwable t) {
            log.error("RedisTemplate\u5f55\u5236executePipelined\u65b9\u6cd5_\u5f55\u5236\u5f02\u5e38", t);
            FlowReplayTrace.remove();
        }
        finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }
}

