/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.CaffeineCacheFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import shaded.com.esotericsoftware.kryo.KryoException;

public class ReplayCaffeineCacheMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ReplayCaffeineCacheMethodInterceptor.class);

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        String methodName = method.getName();
        Assert.state(("build".equals(methodName) || "buildAsync".equals(methodName) ? 1 : 0) != 0, (String)"method name must be 'build', will not be here");
        int parameterCount = method.getParameterCount();
        if ("buildAsync".equals(methodName) && parameterCount == 1) {
            return ret;
        }
        if ("build".equals(methodName) && parameterCount == 0) {
            Cache cache = (Cache)ret;
            return new ReplayLocalCache(cache);
        }
        if ("build".equals(methodName) && parameterCount == 1) {
            LoadingCache cache = (LoadingCache)ret;
            return new ReplayLocalLoadingCache((Cache)cache);
        }
        throw new IllegalStateException("will never be here");
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private static <T> T executeReplay(String methodName, Object key, Callback<T> callback) {
        if (!ReplayCaffeineCacheMethodInterceptor.canReplay(key)) {
            return callback.invoke();
        }
        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();
        CaffeineCacheFlowReplaySpan replayDetailSpan = ReplayCaffeineCacheMethodInterceptor.createReplayDetailSpan(methodName, key, span);
        if (span == null || SpanType.CAFFEINE_CACHE != span.getSpanType()) {
            String expert = SpanType.CAFFEINE_CACHE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        CaffeineCacheFlowReplaySpan caffeineSpan = (CaffeineCacheFlowReplaySpan)span;
        if (!caffeineSpan.getMethodName().equals(methodName)) {
            String expert = caffeineSpan.getMethodName();
            String actual = methodName;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_502, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        Class[] argumentsTypes = new Class[]{key.getClass()};
        if (!FlowReplayUtils.isArgumentsTypesEqual(caffeineSpan.getParameterTypes(), CaffeineCacheFlowReplaySpan.customizeArgumentsTypes(methodName, argumentsTypes))) {
            String expert = FlowReplayUtils.stringArrayToString(caffeineSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(argumentsTypes);
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_500, expert, actual);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        Object[] allArguments = new Object[]{key};
        try {
            Object[] recordParams = caffeineSpan.getParameterValues();
            Object[] replayParams = CaffeineCacheFlowReplaySpan.customizeParameterValues(methodName, allArguments);
            Set<StepDiffColumn> stepDiffColumns = FlowReplayUtils.compareArray(ReplayTraceContext.getContextTraceId(), ReplayTraceContext.getCurrentSpanIdx(), recordParams, replayParams);
            ReplayTraceContext.addAllStepDiffColumns(stepDiffColumns);
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_503, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
        try {
            Object mockRet = caffeineSpan.getReturnValue();
            replayDetailSpan.setRet(mockRet);
            return (T)mockRet;
        }
        catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_504, e);
            throw new PluginException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }

    private static CaffeineCacheFlowReplaySpan createReplayDetailSpan(String methodName, Object key, FlowReplaySpan span) {
        Object[] allArguments = new Object[]{key};
        Class[] argumentsTypes = new Class[]{key.getClass()};
        CaffeineCacheFlowReplaySpan replayDetailSpan = CaffeineCacheFlowReplaySpan.createSpan(methodName, allArguments, argumentsTypes, null);
        replayDetailSpan.setTraceId(FlowReplayTrace.getCurrentTraceId());
        if (span != null) {
            replayDetailSpan.setSpanId(span.getSpanId());
        }
        FlowReplayTrace.addSubSpan(replayDetailSpan);
        return replayDetailSpan;
    }

    private static boolean canReplay(Object arg) {
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return false;
        }
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                if (o == null || !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(o.getClass().getName())) continue;
                return false;
            }
        }
        return !FlowReplayConstants.CANNOT_DESERIALIZE_CLASSES.contains(arg.getClass().getName());
    }

    private static interface Callback<R> {
        public R invoke();
    }

    static class ReplayLocalLoadingCache<K, V>
    extends ReplayLocalCache<K, V>
    implements LoadingCache<K, V> {
        private ReplayLocalLoadingCache(Cache<K, V> cache) {
            super(cache);
        }

        @Override
        protected LoadingCache<K, V> getCache() {
            return (LoadingCache)super.getCache();
        }

        @CheckForNull
        public V get(@Nonnull K key) {
            return (V)ReplayCaffeineCacheMethodInterceptor.executeReplay("get", key, () -> this.getCache().get(key));
        }

        @Nonnull
        public Map<K, V> getAll(@Nonnull Iterable<? extends K> keys) {
            return (Map)ReplayCaffeineCacheMethodInterceptor.executeReplay("getAll", keys, () -> this.getCache().getAll(keys));
        }

        public void refresh(@Nonnull K key) {
            this.getCache().refresh(key);
        }
    }

    static class ReplayLocalCache<K, V>
    implements Cache<K, V> {
        private Cache<K, V> cache;

        private ReplayLocalCache(Cache<K, V> cache) {
            this.cache = cache;
        }

        protected Cache<K, V> getCache() {
            return this.cache;
        }

        @CheckForNull
        public V getIfPresent(@Nonnull Object key) {
            return (V)ReplayCaffeineCacheMethodInterceptor.executeReplay("getIfPresent", key, () -> this.getCache().getIfPresent(key));
        }

        @CheckForNull
        public V get(@Nonnull K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
            return (V)ReplayCaffeineCacheMethodInterceptor.executeReplay("get", key, () -> this.getCache().get(key, mappingFunction));
        }

        @Nonnull
        public Map<K, V> getAllPresent(@Nonnull Iterable<?> keys) {
            return (Map)ReplayCaffeineCacheMethodInterceptor.executeReplay("getAllPresent", keys, () -> this.getCache().getAllPresent(keys));
        }

        public void put(@Nonnull K key, @Nonnull V value) {
            this.getCache().put(key, value);
        }

        public void putAll(@Nonnull Map<? extends K, ? extends V> map) {
            this.getCache().putAll(map);
        }

        public void invalidate(@Nonnull Object key) {
            this.getCache().invalidate(key);
        }

        public void invalidateAll(@Nonnull Iterable<?> keys) {
            this.getCache().invalidateAll(keys);
        }

        public void invalidateAll() {
            this.getCache().invalidateAll();
        }

        public long estimatedSize() {
            return this.getCache().estimatedSize();
        }

        @Nonnull
        public CacheStats stats() {
            return this.getCache().stats();
        }

        @Nonnull
        public ConcurrentMap<K, V> asMap() {
            return this.getCache().asMap();
        }

        public void cleanUp() {
            this.getCache().cleanUp();
        }

        @Nonnull
        public Policy<K, V> policy() {
            return this.getCache().policy();
        }
    }
}

