/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.StandardSpan;
import org.aspectj.lang.reflect.MethodSignature;

public class RemoteServiceFlowReplaySpan
extends StandardSpan {
    private static final long serialVersionUID = 5423363027351871396L;
    private String apiName;
    private String typeName;
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.REMOTE_SERVICE;
    }

    public static RemoteServiceFlowReplaySpan createSpan(MethodSignature methodSignature, Object[] parameterValues) {
        Class[] parameterTypeClasses = methodSignature.getParameterTypes();
        String[] parameterTypes = null;
        if (parameterTypeClasses.length > 0) {
            parameterTypes = new String[parameterTypeClasses.length];
            for (int i = 0; i < parameterTypeClasses.length; ++i) {
                parameterTypes[i] = parameterTypeClasses[i].getName();
            }
        }
        Class returnTypeClass = methodSignature.getReturnType();
        RemoteServiceFlowReplaySpan span = new RemoteServiceFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setParameterTypes(parameterTypes);
        span.setParameterValues(parameterValues);
        span.setReturnType(returnTypeClass != null ? returnTypeClass.getName() : null);
        span.setMethodName(methodSignature.getName());
        span.apiName = FlowReplayUtils.parseApiNameByMethodSignature(methodSignature);
        span.typeFullPath = methodSignature.getDeclaringTypeName();
        span.typeName = methodSignature.getDeclaringType().getSimpleName();
        return span;
    }

    public static RemoteServiceFlowReplaySpan createSpan(RemoteServiceFlowReplaySpan spanTemp) {
        RemoteServiceFlowReplaySpan span = new RemoteServiceFlowReplaySpan();
        span.setTraceId(spanTemp.getTraceId());
        span.setSpanId(spanTemp.getSpanId());
        span.setMethodName(spanTemp.getMethodName());
        span.setParameterTypes(spanTemp.getParameterTypes());
        span.setParameterValues(spanTemp.getParameterValues());
        span.setReturnType(spanTemp.getReturnType());
        span.apiName = spanTemp.apiName;
        span.typeFullPath = spanTemp.typeFullPath;
        span.typeName = spanTemp.typeName;
        return span;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTypeFullPath() {
        return this.typeFullPath;
    }
}

