/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import cn.com.duiba.boot.utils.JarVersionUtils;
import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.EurekaClientUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.MessageListenerConcurrentlyWrapper;
import cn.com.duibaboot.ext.autoconfigure.rocketmq.MessageListenerOrderlyWrapper;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.shared.Application;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyContext;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RocketMqMessageListenerPostProcessor4Group
implements SpecifiedBeanPostProcessor<MessageListener>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RocketMqMessageListenerPostProcessor4Group.class);
    private ApplicationContext applicationContext;
    @Value(value="${duiba.service.group.key:}")
    private String currentServerGroupKey;
    @Value(value="${spring.application.name}")
    private String currentApplicationName;
    @Resource
    private CloseableHttpClient httpClient;

    @Override
    public Class<MessageListener> getBeanType() {
        return MessageListener.class;
    }

    @Override
    public Object postProcessBeforeInitialization(MessageListener bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(MessageListener bean, String beanName) throws BeansException {
        if (Arrays.stream(this.applicationContext.getEnvironment().getActiveProfiles()).filter(s -> s.startsWith("prod")).findAny().isPresent()) {
            return bean;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)bean);
        factory.addAdvice((Advice)new MessageListenerMethodInterceptor(this.currentServerGroupKey, this.applicationContext, this.currentApplicationName, this.httpClient));
        return factory.getProxy();
    }

    public int getOrder() {
        return 0;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static class RocketMqRunInOtherNodeTask
    implements Callable<Object>,
    Serializable {
        @Resource
        private transient ApplicationContext applicationContext;
        private String beanName;
        private List<MessageExt> msgs;
        private MessageQueue messageQueue;
        private int delayLevelWhenNextConsume;
        private int ackIndex;
        private boolean autoCommit = true;
        private long suspendCurrentQueueTimeMillis = -1L;

        @Override
        public Object call() {
            MessageListener listener;
            try {
                listener = (MessageListener)this.applicationContext.getBean(this.beanName, MessageListener.class);
            }
            catch (BeanNotOfRequiredTypeException | NoSuchBeanDefinitionException e) {
                throw new IllegalStateException("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u627e\u4e0d\u5230beanName\u4e3a" + this.beanName + "\u7684messageListener\uff0c\u65e0\u6cd5\u6d88\u8d39\u591a\u573a\u666f\u7684rocketmq\u6d88\u606f\uff1b\u591a\u573a\u666f\u6d4b\u8bd5\u65f6\u8bf7\u81f3\u5c11\u4fdd\u8bc1\u9879\u76ee\u5404\u4e2a\u5206\u652f\u6709\u4e00\u6837\u540d\u5b57\u7684MessageListener", e);
            }
            if (listener instanceof MessageListenerConcurrently) {
                ConsumeConcurrentlyContext consumeConcurrentlyContext = new ConsumeConcurrentlyContext(this.messageQueue);
                consumeConcurrentlyContext.setAckIndex(this.ackIndex);
                consumeConcurrentlyContext.setDelayLevelWhenNextConsume(this.delayLevelWhenNextConsume);
                return ((MessageListenerConcurrently)listener).consumeMessage(this.msgs, consumeConcurrentlyContext);
            }
            if (listener instanceof MessageListenerOrderly) {
                ConsumeOrderlyContext consumeOrderlyContext = new ConsumeOrderlyContext(this.messageQueue);
                consumeOrderlyContext.setAutoCommit(this.autoCommit);
                consumeOrderlyContext.setSuspendCurrentQueueTimeMillis(this.suspendCurrentQueueTimeMillis);
                return ((MessageListenerOrderly)listener).consumeMessage(this.msgs, consumeOrderlyContext);
            }
            throw new UnsupportedOperationException("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u6682\u672a\u652f\u6301\u7684MessageListener\u7c7b\u578b\uff1a" + listener.getClass().getName());
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        RocketMqRunInOtherNodeTask(ApplicationContext applicationContext, String beanName, List<MessageExt> msgs, MessageQueue messageQueue, int delayLevelWhenNextConsume, int ackIndex, boolean autoCommit, long suspendCurrentQueueTimeMillis) {
            this.applicationContext = applicationContext;
            this.beanName = beanName;
            this.msgs = msgs;
            this.messageQueue = messageQueue;
            this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
            this.ackIndex = ackIndex;
            this.autoCommit = autoCommit;
            this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
        }

        public static RocketMqRunInOtherNodeTaskBuilder builder() {
            return new RocketMqRunInOtherNodeTaskBuilder();
        }

        public static class RocketMqRunInOtherNodeTaskBuilder {
            private ApplicationContext applicationContext;
            private String beanName;
            private List<MessageExt> msgs;
            private MessageQueue messageQueue;
            private int delayLevelWhenNextConsume;
            private int ackIndex;
            private boolean autoCommit;
            private long suspendCurrentQueueTimeMillis;

            RocketMqRunInOtherNodeTaskBuilder() {
            }

            public RocketMqRunInOtherNodeTaskBuilder applicationContext(ApplicationContext applicationContext) {
                this.applicationContext = applicationContext;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder beanName(String beanName) {
                this.beanName = beanName;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder msgs(List<MessageExt> msgs) {
                this.msgs = msgs;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder messageQueue(MessageQueue messageQueue) {
                this.messageQueue = messageQueue;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder delayLevelWhenNextConsume(int delayLevelWhenNextConsume) {
                this.delayLevelWhenNextConsume = delayLevelWhenNextConsume;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder ackIndex(int ackIndex) {
                this.ackIndex = ackIndex;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder autoCommit(boolean autoCommit) {
                this.autoCommit = autoCommit;
                return this;
            }

            public RocketMqRunInOtherNodeTaskBuilder suspendCurrentQueueTimeMillis(long suspendCurrentQueueTimeMillis) {
                this.suspendCurrentQueueTimeMillis = suspendCurrentQueueTimeMillis;
                return this;
            }

            public RocketMqRunInOtherNodeTask build() {
                return new RocketMqRunInOtherNodeTask(this.applicationContext, this.beanName, this.msgs, this.messageQueue, this.delayLevelWhenNextConsume, this.ackIndex, this.autoCommit, this.suspendCurrentQueueTimeMillis);
            }

            public String toString() {
                return "RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask.RocketMqRunInOtherNodeTaskBuilder(applicationContext=" + this.applicationContext + ", beanName=" + this.beanName + ", msgs=" + this.msgs + ", messageQueue=" + this.messageQueue + ", delayLevelWhenNextConsume=" + this.delayLevelWhenNextConsume + ", ackIndex=" + this.ackIndex + ", autoCommit=" + this.autoCommit + ", suspendCurrentQueueTimeMillis=" + this.suspendCurrentQueueTimeMillis + ")";
            }
        }
    }

    private static class MessageListenerMethodInterceptor
    implements MethodInterceptor {
        private String currentServerGroupKey;
        private ApplicationContext applicationContext;
        private String currentApplicationName;
        private CloseableHttpClient httpClient;
        private volatile EurekaClient eurekaClient;
        private volatile long lastRefreshInstancesTime = -1L;

        MessageListenerMethodInterceptor(String currentServerGroupKey, ApplicationContext applicationContext, String currentApplicationName, CloseableHttpClient httpClient) {
            this.currentServerGroupKey = currentServerGroupKey;
            this.applicationContext = applicationContext;
            this.currentApplicationName = currentApplicationName;
            this.httpClient = httpClient;
        }

        private EurekaClient getEurekaClient() {
            if (this.eurekaClient == null) {
                this.eurekaClient = (EurekaClient)this.applicationContext.getBean("eurekaClient", EurekaClient.class);
            }
            return this.eurekaClient;
        }

        private Stream<InstanceInfo> getAllThisServerUpInstances() {
            Application application;
            long now = System.currentTimeMillis();
            if (now - this.lastRefreshInstancesTime > 2000L) {
                EurekaClientUtils.refreshRegistry(this.getEurekaClient());
                this.lastRefreshInstancesTime = now;
            }
            if ((application = this.getEurekaClient().getApplication(this.currentApplicationName)) == null) {
                return Collections.emptyList().stream();
            }
            List instances = application.getInstancesAsIsFromEureka();
            return instances.stream().filter(instanceInfo -> instanceInfo.getStatus() == InstanceInfo.InstanceStatus.UP).filter(instanceInfo -> {
                String duibaBootVersion = (String)instanceInfo.getMetadata().get("duibaBootVersion");
                return JarVersionUtils.isJarVersionEqualOrGreaterThan((String)duibaBootVersion, (String)"1.3.12");
            });
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.startsWith("consumeMessage") && invocation.getMethod().getParameterTypes().length >= 1 && invocation.getMethod().getParameterTypes()[0].equals(List.class)) {
                String beanName = this.resolveBeanName(invocation.getThis());
                if (beanName == null) {
                    return invocation.proceed();
                }
                Object[] args = invocation.getArguments();
                List list = (List)args[0];
                Object messageContext = args[1];
                if (list != null && list.size() == 1) {
                    MessageExt m = (MessageExt)list.get(0);
                    return this.consumeOne(invocation, m, beanName, messageContext);
                }
                if (list != null && list.size() > 1 && this.containsServiceGroupMsg(list)) {
                    logger.warn("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u65e0\u6cd5\u652f\u6301\u4e00\u6b21\u6d88\u8d39\u591a\u6761rocketmq\u6d88\u606f\u3011\u68c0\u6d4b\u5230\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u591a\u573a\u666f\u6d4b\u8bd5\uff0crocketmq\u6d88\u8d39\u8005\u4e00\u6b21\u6d88\u8d39\u4e86\u591a\u6761\u6d88\u606f\u4e14\u6d88\u606f\u4e2d\u6709\u591a\u573a\u666f\u6d4b\u8bd5\u6d88\u606f\uff08\u5982\u9700\u652f\u6301\u591a\u573a\u666f\u6d88\u8d39\u8bf7\u8bbe\u7f6eDefaultMQPushConsumer.setConsumeMessageBatchMaxSize \u4e3a1\uff09");
                }
            }
            return invocation.proceed();
        }

        private String resolveBeanName(Object obj) {
            if (obj instanceof MessageListenerConcurrentlyWrapper) {
                return ((MessageListenerConcurrentlyWrapper)obj).getBeanName();
            }
            if (obj instanceof MessageListenerOrderlyWrapper) {
                return ((MessageListenerOrderlyWrapper)obj).getBeanName();
            }
            logger.warn("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u65e0\u6cd5\u83b7\u53d6beanName\uff0c\u65e0\u6cd5\u652f\u6301rocketmq\u591a\u573a\u666f\u6d4b\u8bd5\uff0c\u5e94\u8be5\u662fBeanPostProcessor\u987a\u5e8f\u4e71\u4e86\u5bfc\u81f4\u7684");
            return null;
        }

        private boolean canProcessByCurrentMachine(String serviceGroupKeyOfMessage) {
            String ipFromMessage;
            if (serviceGroupKeyOfMessage.equals(this.currentServerGroupKey)) {
                return true;
            }
            return serviceGroupKeyOfMessage.startsWith("dev_ip_") && (ipFromMessage = serviceGroupKeyOfMessage.substring("dev_ip_".length())).equals(NetUtils.getLocalIp());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object consumeOne(MethodInvocation invocation, MessageExt m, String beanName, Object messageContext) throws Throwable {
            String serviceGroupKeyOfMessage = m.getUserProperty("_duibaServiceGroupKey");
            if (StringUtils.isNotBlank((CharSequence)serviceGroupKeyOfMessage)) {
                if (this.canProcessByCurrentMachine(serviceGroupKeyOfMessage)) {
                    logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}\uff0c\u4e0e\u672c\u673a\u5339\u914d\uff0c\u5c06\u7531\u5f53\u524d\u670d\u52a1\u5668\u76f4\u63a5\u5904\u7406.", (Object)m.getTopic(), (Object)serviceGroupKeyOfMessage);
                    ServiceGroupContext.setGroupKey(serviceGroupKeyOfMessage);
                    try {
                        Object object = invocation.proceed();
                        return object;
                    }
                    finally {
                        ServiceGroupContext.removeGroupKey();
                    }
                }
                InstanceInfo selectedInstance = this.getAllThisServerUpInstances().filter(instanceInfo -> {
                    String nodeIp;
                    String ipFromMessage;
                    String memberServiceGroupKey = (String)instanceInfo.getMetadata().get("duiba.service.group.key");
                    if (serviceGroupKeyOfMessage.equals(memberServiceGroupKey)) {
                        return true;
                    }
                    return serviceGroupKeyOfMessage.startsWith("dev_ip_") && (ipFromMessage = serviceGroupKeyOfMessage.substring("dev_ip_".length())).equals(nodeIp = instanceInfo.getIPAddr());
                }).findAny().orElseGet(() -> {
                    if (StringUtils.isBlank((CharSequence)this.currentServerGroupKey)) {
                        return null;
                    }
                    return this.getAllThisServerUpInstances().filter(instanceInfo -> {
                        String memberServiceGroupKey = (String)instanceInfo.getMetadata().get("duiba.service.group.key");
                        return StringUtils.isBlank((CharSequence)memberServiceGroupKey);
                    }).findAny().orElse(null);
                });
                if (selectedInstance != null) {
                    String memberServiceGroupKey = (String)selectedInstance.getMetadata().get("duiba.service.group.key");
                    if (serviceGroupKeyOfMessage.equals(memberServiceGroupKey)) {
                        logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}\uff0c\u4e0e\u672c\u673a\u4e0d\u5339\u914d\uff0c\u8f6c\u53d1\u7ed9\u5177\u6709\u76f8\u540c\u573a\u666fID\u7684\u76ee\u6807\u673a\u5668:{}\u8fdb\u884c\u5904\u7406.", new Object[]{m.getTopic(), serviceGroupKeyOfMessage, selectedInstance.getIPAddr()});
                    } else {
                        logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u591a\u573a\u666f\u670d\u52a1\u5b9e\u4f8b\uff0c\u5c06\u8f6c\u53d1\u7ed9\u4e0d\u5e26\u573a\u666fID\u670d\u52a1\u5668\uff1a{}\u8fdb\u884c\u5904\u7406.", new Object[]{m.getTopic(), serviceGroupKeyOfMessage, selectedInstance.getIPAddr()});
                    }
                    return this.submitConsumeTask2otherNode(m, messageContext, beanName, selectedInstance);
                }
                logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u591a\u573a\u666f\u670d\u52a1\u5b9e\u4f8b\uff0c\u5f53\u524d\u670d\u52a1\u5668\u5c06\u4f1a\u76f4\u63a5\u5904\u7406.", (Object)m.getTopic(), (Object)serviceGroupKeyOfMessage);
                ServiceGroupContext.setGroupKey(serviceGroupKeyOfMessage);
                try {
                    Object object = invocation.proceed();
                    return object;
                }
                finally {
                    ServiceGroupContext.removeGroupKey();
                }
            }
            if (StringUtils.isBlank((CharSequence)this.currentServerGroupKey)) {
                logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}, \u5c06\u7531\u672c\u673a\u76f4\u63a5\u5904\u7406", (Object)m.getTopic(), (Object)serviceGroupKeyOfMessage);
                return invocation.proceed();
            }
            InstanceInfo selectedInstance = this.getAllThisServerUpInstances().filter(instanceInfo -> StringUtils.isBlank((CharSequence)((CharSequence)instanceInfo.getMetadata().get("duiba.service.group.key")))).findAny().orElse(null);
            if (selectedInstance != null) {
                logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}, \u5c06\u8f6c\u53d1\u7ed9\u540c\u6837\u6ca1\u6709\u591a\u573a\u666fID\u7684\u670d\u52a1\u5668{}\u8fdb\u884c\u5904\u7406", new Object[]{m.getTopic(), serviceGroupKeyOfMessage, selectedInstance.getIPAddr()});
                return this.submitConsumeTask2otherNode(m, messageContext, beanName, selectedInstance);
            }
            logger.info("\u3010RocketMQ\u591a\u573a\u666f\u6d4b\u8bd5\u3011\u5f53\u524d\u6536\u5230\u6d88\u606f\u7684topic:{}, \u591a\u573a\u666fkey:{}, \u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6ca1\u6709\u591a\u573a\u666fId\u7684\u670d\u52a1\u5668\uff0c\u5c06\u7531\u672c\u673a\u76f4\u63a5\u5904\u7406", (Object)m.getTopic(), (Object)serviceGroupKeyOfMessage);
            return invocation.proceed();
        }

        private Object submitConsumeTask2otherNode(MessageExt m, Object messageContext, String beanName, InstanceInfo selectedInstance) throws IOException {
            ConsumeConcurrentlyContext c;
            String rocketMQMsgDispatchUrl = selectedInstance.getHomePageUrl();
            if (StringUtils.isBlank((CharSequence)rocketMQMsgDispatchUrl)) {
                rocketMQMsgDispatchUrl = "http://" + selectedInstance.getIPAddr() + ":" + selectedInstance.getPort();
            }
            if (!rocketMQMsgDispatchUrl.endsWith("/")) {
                rocketMQMsgDispatchUrl = rocketMQMsgDispatchUrl.substring(0, rocketMQMsgDispatchUrl.length() - 1);
            }
            rocketMQMsgDispatchUrl = rocketMQMsgDispatchUrl + "/bootext/serviceGroup/rocketmqMsgDispatch";
            RocketMqRunInOtherNodeTask.RocketMqRunInOtherNodeTaskBuilder builder = RocketMqRunInOtherNodeTask.builder().beanName(beanName).msgs(Arrays.asList(m));
            if (messageContext instanceof ConsumeConcurrentlyContext) {
                c = (ConsumeConcurrentlyContext)messageContext;
                builder.messageQueue(c.getMessageQueue());
                builder.ackIndex(c.getAckIndex());
                builder.delayLevelWhenNextConsume(c.getDelayLevelWhenNextConsume());
            } else if (messageContext instanceof ConsumeOrderlyContext) {
                c = (ConsumeOrderlyContext)messageContext;
                builder.messageQueue(c.getMessageQueue());
                builder.suspendCurrentQueueTimeMillis(c.getSuspendCurrentQueueTimeMillis());
                builder.autoCommit(c.isAutoCommit());
            }
            RocketMqRunInOtherNodeTask task = builder.build();
            HttpPost req = new HttpPost(rocketMQMsgDispatchUrl);
            byte[] bs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(task);
            ByteArrayEntity entity = new ByteArrayEntity(bs);
            req.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)req);){
                Object objectToReturn;
                byte[] retBs = IOUtils.toByteArray((InputStream)resp.getEntity().getContent());
                Object t = objectToReturn = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(retBs);
                return t;
            }
        }

        private boolean containsServiceGroupMsg(List<MessageExt> list) {
            return list.stream().filter(messageExt -> StringUtils.isNotBlank((CharSequence)messageExt.getUserProperty("_duibaServiceGroupKey"))).count() > 0L;
        }
    }
}

