/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.minbin;

import java.lang.reflect.Array;
import shaded.org.nustaq.serialization.minbin.MinBin;

public class MBOut {
    byte[] bytez = new byte[500];
    int pos = 0;
    MinBin mb;

    public MBOut() {
        this(MinBin.DefaultInstance);
    }

    public MBOut(MinBin mb) {
        this.mb = mb;
    }

    void writeOut(byte b) {
        if (this.pos == this.bytez.length - 1) {
            this.resize();
        }
        this.bytez[this.pos++] = b;
    }

    private void resize() {
        byte[] tmp = new byte[Math.min(this.bytez.length + 50000000, this.bytez.length * 2)];
        System.arraycopy(this.bytez, 0, tmp, 0, this.pos);
        this.bytez = tmp;
    }

    public void writeInt(byte type, long data) {
        if (!MinBin.isPrimitive(type) || MinBin.isArray(type)) {
            throw new RuntimeException("illegal type code");
        }
        this.writeOut(type);
        this.writeRawInt(type, data);
    }

    protected void writeRawInt(byte type, long data) {
        int numBytes = MinBin.extractNumBytes(type);
        for (int i = 0; i < numBytes; ++i) {
            this.writeOut((byte)(data & 0xFFL));
            data >>>= 8;
        }
    }

    public void writeIntPacked(long data) {
        if (data <= 127L && data >= -128L) {
            this.writeInt((byte)1, data);
        } else if (data <= 32767L && data >= -32768L) {
            this.writeInt((byte)2, data);
        } else if (data <= Integer.MAX_VALUE && data >= Integer.MIN_VALUE) {
            this.writeInt((byte)3, data);
        } else if (data <= Long.MAX_VALUE && data >= Long.MIN_VALUE) {
            this.writeInt((byte)4, data);
        }
    }

    public void writeArray(Object primitiveArray, int start, int len) {
        byte type = 16;
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (componentType == Boolean.TYPE) {
            type = (byte)(type | 1);
        } else if (componentType == Byte.TYPE) {
            type = (byte)(type | 1);
        } else if (componentType == Short.TYPE) {
            type = (byte)(type | 2);
        } else if (componentType == Character.TYPE) {
            type = (byte)(type | 0xA);
        } else if (componentType == Integer.TYPE) {
            type = (byte)(type | 3);
        } else if (componentType == Long.TYPE) {
            type = (byte)(type | 4);
        } else {
            throw new RuntimeException("unsupported type " + componentType.getName());
        }
        this.writeOut(type);
        this.writeIntPacked(len);
        switch (type) {
            case 17: {
                if (componentType == Boolean.TYPE) {
                    boolean[] arr = (boolean[])primitiveArray;
                    for (int i = start; i < start + len; ++i) {
                        this.writeRawInt(type, arr[i] ? 1L : 0L);
                    }
                } else {
                    byte[] arr = (byte[])primitiveArray;
                    for (int i = start; i < start + len; ++i) {
                        this.writeRawInt(type, arr[i]);
                    }
                }
                break;
            }
            case 26: {
                char[] charArr = (char[])primitiveArray;
                for (int i = start; i < start + len; ++i) {
                    this.writeRawInt(type, charArr[i]);
                }
                break;
            }
            case 19: {
                int[] arr = (int[])primitiveArray;
                for (int i = start; i < start + len; ++i) {
                    this.writeRawInt(type, arr[i]);
                }
                break;
            }
            case 20: {
                long[] arr = (long[])primitiveArray;
                for (int i = start; i < start + len; ++i) {
                    this.writeRawInt(type, arr[i]);
                }
                break;
            }
            default: {
                for (int i = start; i < start + len; ++i) {
                    if (componentType == Boolean.TYPE) {
                        this.writeRawInt(type, Array.getBoolean(primitiveArray, i) ? 1L : 0L);
                        continue;
                    }
                    this.writeRawInt(type, Array.getLong(primitiveArray, i));
                }
            }
        }
    }

    public void writeTagHeader(byte tagId) {
        this.writeOut(MinBin.getTagCode(tagId));
    }

    public void writeTag(Object obj) {
        if (MinBin.END_MARKER == obj) {
            this.writeOut((byte)6);
            return;
        }
        MinBin.TagSerializer tagSerializer = this.mb.getSerializerFor(obj);
        if (tagSerializer == null) {
            throw new RuntimeException("no tag serializer found for " + obj.getClass().getName());
        }
        this.writeTagHeader((byte)tagSerializer.getTagId());
        tagSerializer.writeTag(obj, this);
    }

    public int getWritten() {
        return this.pos;
    }

    public byte[] getBytez() {
        return this.bytez;
    }

    public void reset() {
        this.pos = 0;
    }

    public void reset(byte[] bytez) {
        this.pos = 0;
        this.bytez = bytez;
    }

    public void resetPosition() {
        this.pos = 0;
    }

    public void writeObject(Object o) {
        if (o == null) {
            this.writeTag(o);
        } else if (o.getClass().isPrimitive() && o.getClass() != Float.TYPE && o.getClass() != Double.TYPE) {
            this.writeIntPacked(((Number)o).longValue());
        } else if (o.getClass().isArray() && o.getClass().getComponentType() != Float.TYPE && o.getClass().getComponentType() != Double.TYPE) {
            this.writeArray(o, 0, Array.getLength(o));
        } else if (o.getClass() == Byte.class) {
            this.writeInt((byte)1, ((Number)o).longValue());
        } else if (o.getClass() == Short.class) {
            this.writeInt((byte)2, ((Number)o).longValue());
        } else if (o.getClass() == Character.class) {
            this.writeInt((byte)10, ((Character)o).charValue());
        } else if (o.getClass() == Integer.class) {
            this.writeInt((byte)3, ((Number)o).longValue());
        } else if (o.getClass() == Long.class) {
            this.writeInt((byte)4, ((Number)o).longValue());
        } else {
            this.writeTag(o);
        }
    }

    public void writeRaw(byte[] bufferedName, int i, int length) {
        if (this.pos + length >= this.bytez.length - 1) {
            this.resize();
        }
        System.arraycopy(bufferedName, i, this.bytez, this.pos, length);
        this.pos += length;
    }
}

