/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.nustaq.serialization.util;

import shaded.org.nustaq.serialization.util.FSTObject2IntMap;
import shaded.org.nustaq.serialization.util.FSTUtil;

public class FSTInt2IntMap {
    public int[] mKeys;
    public int[] mValues;
    public int mNumberOfElements;
    FSTInt2IntMap next;
    private static final int GROWFAC = 2;

    public FSTInt2IntMap(int initialSize) {
        if (initialSize < 2) {
            initialSize = 2;
        }
        initialSize = FSTObject2IntMap.adjustSize(initialSize * 2);
        this.mKeys = new int[initialSize];
        this.mValues = new int[initialSize];
        this.mNumberOfElements = 0;
    }

    public int size() {
        return this.mNumberOfElements + (this.next != null ? this.next.size() : 0);
    }

    public final void put(int key, int value) {
        int idx;
        int mKey;
        int hash = key & Integer.MAX_VALUE;
        if (key == 0 && value == 0 || value == Integer.MIN_VALUE) {
            throw new RuntimeException("key value pair not supported " + key + " " + value);
        }
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            this.resize(this.mKeys.length * 2);
        }
        if ((mKey = this.mKeys[idx = hash % this.mKeys.length]) == 0 && this.mValues[idx] == 0) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (mKey == key) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final void putHash(int key, int value, int hash, FSTInt2IntMap parent) {
        int idx;
        int mKey;
        if (this.mNumberOfElements * 2 > this.mKeys.length) {
            if (parent != null) {
                if ((parent.mNumberOfElements + this.mNumberOfElements) * 2 > parent.mKeys.length) {
                    parent.resize(parent.mKeys.length * 2);
                    parent.put(key, value);
                    return;
                }
                this.resize(this.mKeys.length * 2);
            } else {
                this.resize(this.mKeys.length * 2);
            }
        }
        if ((mKey = this.mKeys[idx = hash % this.mKeys.length]) == 0 && this.mValues[idx] == 0) {
            ++this.mNumberOfElements;
            this.mValues[idx] = value;
            this.mKeys[idx] = key;
        } else if (mKey == key) {
            this.mValues[idx] = value;
        } else {
            this.putNext(hash, key, value);
        }
    }

    final void putNext(int hash, int key, int value) {
        if (this.next == null) {
            int newSiz = this.mNumberOfElements / 3;
            this.next = new FSTInt2IntMap(newSiz);
        }
        this.next.putHash(key, value, hash, this);
    }

    public final int get(int key) {
        int hash = key & Integer.MAX_VALUE;
        return this.getHash(key, hash);
    }

    final int getHash(int key, int hash) {
        int idx = hash % this.mKeys.length;
        int mKey = this.mKeys[idx];
        if (mKey == 0 && this.mValues[idx] == 0) {
            return Integer.MIN_VALUE;
        }
        if (mKey == key) {
            return this.mValues[idx];
        }
        if (this.next == null) {
            return Integer.MIN_VALUE;
        }
        return this.next.getHash(key, hash);
    }

    final void resize(int newSize) {
        newSize = FSTObject2IntMap.adjustSize(newSize);
        int[] oldTabKey = this.mKeys;
        int[] oldTabVal = this.mValues;
        this.mKeys = new int[newSize];
        this.mValues = new int[newSize];
        this.mNumberOfElements = 0;
        for (int n = 0; n < oldTabKey.length; ++n) {
            if (oldTabKey[n] == 0 && oldTabVal[n] == 0) continue;
            this.put(oldTabKey[n], oldTabVal[n]);
        }
        if (this.next != null) {
            FSTInt2IntMap oldNext = this.next;
            this.next = null;
            oldNext.rePut(this);
        }
    }

    private void rePut(FSTInt2IntMap kfstObject2IntMap) {
        for (int i = 0; i < this.mKeys.length; ++i) {
            int mKey = this.mKeys[i];
            if (mKey == 0 && this.mValues[i] == 0) continue;
            kfstObject2IntMap.put(mKey, this.mValues[i]);
        }
        if (this.next != null) {
            this.next.rePut(kfstObject2IntMap);
        }
    }

    public void clear() {
        FSTUtil.clear(this.mKeys);
        FSTUtil.clear(this.mValues);
        this.mNumberOfElements = 0;
        if (this.next != null) {
            this.next.clear();
        }
    }
}

