package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.common.base.Joiner;
import io.elasticjob.lite.internal.monitor.MonitorService;
import io.elasticjob.lite.internal.schedule.JobRegistry;
import io.elasticjob.lite.reg.base.CoordinatorRegistryCenter;

import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.util.ReflectionUtils;

/**
 * 查看elastic-job的监控数据
 */
public class ElasticJobMonitorEndpointV3 extends AbstractEndpoint<String> {

    public ElasticJobMonitorEndpointV3() {
        super("elasticJobMonitor");
    }

    @Override
    public String invoke() {
        return genFromElasticJob3();
    }

    public String genFromElasticJob3(){
        JobRegistry jobRegistry = JobRegistry.getInstance();
        Field regCenterMapField = ReflectionUtils.findField(jobRegistry.getClass(), "regCenterMap");
        regCenterMapField.setAccessible(true);
        Map<String, CoordinatorRegistryCenter> regCenterMap = (Map<String, CoordinatorRegistryCenter>)ReflectionUtils.getField(regCenterMapField, jobRegistry);

        Method dumpDirectlyMethod = ReflectionUtils.findMethod(MonitorService.class, "dumpDirectly", String.class, List.class);
        dumpDirectlyMethod.setAccessible(true);
        final StringBuilder sb = new StringBuilder();
        regCenterMap.forEach((jobName, regCenter) -> {
            MonitorService ms = new MonitorService(regCenter, jobName);
            List<String> result = new ArrayList<>();
            ReflectionUtils.invokeMethod(dumpDirectlyMethod, ms, "/" + jobName, result);
            String jobMonitorData = Joiner.on("\n").join(result);

            sb.append("----").append("jobName:").append(jobName).append("----\n").append(jobMonitorData).append("\n");
        });

        return sb.toString();
    }

}
