package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import java.util.Arrays;
import java.util.List;

/**
 * 引流回归常量表
 * Created by guoyanfei .
 * 2019-01-29 .
 */
public class FlowReplayConstants {

    public static final int DB_TIME_PROFILE_THRESHOLD = 1000000;

    public static final String DEFAULT_UUID = "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%";

    public static final List<String> COLUMN_NAME_WHITELIST = Arrays.asList("sign");

    public static final String LOCAL_FLOWREPLAY_DIR = "/data/flowreplay/";

    /**
     * 录制文件的path
     */
    public static final String LOCAL_RECORD_FILEPATH = "/data/flowreplay/flow_record";

    /**
     * 录制详情文件
     * | version(4) | count(4) | idxIndex(8)
     * | tradeDetail1.length(4) | tradeDetail1
     * | tradeDetail2.length(4) | tradeDetail2
     * | tradeDetail3.length(4) | tradeDetail3
     * | tradeDetail4.length(4) | tradeDetail4
     * ...
     * | traceId1.length(4) | traceId1 | tradeDetail1Index(8)
     * | traceId2.length(4) | traceId2 | tradeDetail2Index(8)
     * | traceId3.length(4) | traceId3 | tradeDetail3Index(8)
     * | traceId4.length(4) | traceId4 | tradeDetail4Index(8)
     * ...
     * (以上为了方便注释的可读性而换行，实际文件不换行)
     */
    public static final String LOCAL_RECORD_DETAIL_FILEPATH = "/data/flowreplay/flow_record_detail";

    /**
     * 回归结果的文件path
     */
    public static final String LOCAL_RESULT_FILEPATH = "/data/flowreplay/replay_result";
    
    /**
     * 回归详情文件(格式同录制详情文件)
     * | version(4) | count(4) | idxIndex(8)
     * | tradeDetail1.length(4) | tradeDetail1
     * | tradeDetail2.length(4) | tradeDetail2
     * | tradeDetail3.length(4) | tradeDetail3
     * | tradeDetail4.length(4) | tradeDetail4
     * ...
     * | traceId1.length(4) | traceId1 | tradeDetail1Index(8)
     * | traceId2.length(4) | traceId2 | tradeDetail2Index(8)
     * | traceId3.length(4) | traceId3 | tradeDetail3Index(8)
     * | traceId4.length(4) | traceId4 | tradeDetail4Index(8)
     * ...
     * (以上为了方便注释的可读性而换行，实际文件不换行)
     */
    public static final String LOCAL_REPLAY_DETAIL_FILEPATH = "/data/flowreplay/flow_replay_detail";

    public static final String LOCAL_RECORD_LOG_PATH = "/data/flowreplaylog/recordlog";

    public static final String LOCAL_REPLAY_LOG_PATH = "/data/flowreplaylog/replaylog";

    /**
     * 录制文件的版本
     */
    public static final int RECORD_FILE_VERSION = 1;

    /**
     * 录制详情文件的版本
     */
    public static final int RECORD_DETAIL_FILE_VERSION = 1;

    /**
     * 回归结果文件的版本
     */
    public static final int REPLAY_RESULT_FILE_VERSION = 1;

    /**
     * guava cache方法拦截器拦截的方法白名单
     */
    public static final List<String> GUAVA_CACHE_AOP_METHOD = Arrays.asList("getIfPresent",
                                                                            "get",
                                                                            "getAllPresent",
                                                                            "getUnchecked",
                                                                            "getAll");

    /**
     * redis拦截器排除不拦截的方法
     */
    public static final List<String> REDIS_AOP_EXCLUDE_METHOD = Arrays.asList("connect",
                                                                              "auth",
                                                                              "checkIsInMultiOrPipeline",
                                                                              "getDB",
                                                                              "setDataSource",
                                                                              "getClient",
                                                                              "close",
                                                                              "ping",
                                                                              "isConnected",
                                                                              "quit",
                                                                              "disconnect",
                                                                              "resetState",
                                                                              "isConnected",
                                                                              "toString",
                                                                              "hashCode",
                                                                              "equals");


    /**
     * http录制排除的几个uri
     */
    public static final List<String> HTTP_EXCLUDE_URI = Arrays.asList("/flow/record",
                                                                    "/flow/record/stop",
                                                                    "/flow/record/result",
                                                                    "/flow/repaly",
                                                                    "/flow/replay/stop",
                                                                    "/flow/replay/result");

    /**
     * 无法kryo序列化的类，方法拦截器不拦截参数或者返回值类型是这几个类的接口
     */
    public static final List<String> CANNOT_DESERIALIZE_CLASSES = Arrays.asList("com.netflix.loadbalancer.Server",
                                                                                  "org.springframework.cloud.netflix.ribbon.eureka.DomainExtractingServer");

}
