package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

@Data
public class JsonResult<T> {

    private boolean success;
    private String  message;
    private T       data;

    /**
     * @param data
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> successResult(T data) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(true);
        jsonResult.setData(data);
        return jsonResult;
    }

    /**
     * @param message
     * @param <T>
     * @return
     */
    public static <T> JsonResult<T> failedResult(String message) {
        JsonResult<T> jsonResult = new JsonResult<>();
        jsonResult.setSuccess(false);
        jsonResult.setMessage(message);
        jsonResult.setData(null);
        return jsonResult;
    }

    public String toJSONString() {
        return JSONObject.toJSONString(this);
    }

}
