package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayErrorMsgTypeEnum;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplayTrace;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 回归单个trace的结果
 * Created by guoyanfei .
 * 2019-03-13 .
 */
@Data
public class ReplayTraceResult implements Serializable {

    private static final long serialVersionUID = 7099777871469745441L;

    private String traceId;

    private FlowReplaySpan mainSpan;

    /**
     * 回归成功
     */
    private boolean success;

    private String errorMsg;

    private String errorMsgDetail;

    /**
     * 返回值
     * 回归成功才会有
     * remoteService: 具体的类的对象
     * http: byte[] responseBody
     */
    private Object returnValue;

    /**
     * 中间步骤对比不一致字段list
     */
    private Set<StepDiffColumn> stepDiffColumns;

    /**
     * 回归详情的traceId
     * 不需要序列化
     */
    private transient FlowReplayTrace replayDetailTrace;

    public static ReplayTraceResult successResult(FlowReplayTrace trace, FlowReplayTrace replayDetailTrace, Object returnValue, Set<StepDiffColumn> stepDiffColumns) {
        ReplayTraceResult result = new ReplayTraceResult();
        result.traceId = trace.getTraceId();
        result.mainSpan = trace.getMainSpan();
        result.success = true;
        result.errorMsg = null;
        result.returnValue = returnValue;
        result.replayDetailTrace = replayDetailTrace;
        result.stepDiffColumns = stepDiffColumns;
        return result;
    }

    public static ReplayTraceResult failResult(FlowReplayTrace trace,FlowReplayTrace replayDetailTrace, FlowReplayErrorMsgTypeEnum errorMsgType, Set<StepDiffColumn> stepDiffColumns) {
        return failResult(trace, replayDetailTrace, errorMsgType, null, stepDiffColumns);
    }

    public static ReplayTraceResult failResult(FlowReplayTrace trace, FlowReplayTrace replayDetailTrace, FlowReplayErrorMsgTypeEnum errorMsgType, String detail, Set<StepDiffColumn> stepDiffColumns) {
        ReplayTraceResult result = new ReplayTraceResult();
        result.traceId = trace.getTraceId();
        result.mainSpan = trace.getMainSpan();
        result.success = false;
        result.errorMsg = errorMsgType.desc();
        result.errorMsgDetail = detail;
        result.returnValue = null;
        result.replayDetailTrace = replayDetailTrace;
        result.stepDiffColumns = stepDiffColumns;
        return result;
    }

}
