package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import org.springframework.context.ApplicationContext;

/**
 * 服务分组用的Filter；
 * 1. 当从request中识别到需要分组的请求时，设置context
 * 2. 接受从同一个应用的其他实例转发过来的rocketmq消息, 以支持rocketmq的多场景测试
 *
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public class ServiceGroupFilter implements Filter {

    public static final String ROCKETMQ_MSG_DISPATCH_PATH = "/bootext/serviceGroup/rocketmqMsgDispatch";

    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey((HttpServletRequest) request);
        HttpServletRequest req = (HttpServletRequest) request;
        if(groupKey == null && SpringEnvironmentUtils.isDevEnv()){//开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
            String ip = RequestTool.getIpAddr(req);
            if(ip.equals("127.0.0.1")){
                ip = NetUtils.getLocalIp();
            }
            groupKey = ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + ip;
        }

        if (StringUtils.isNotBlank(groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }

        String uri = RequestUtils.getRequestPath(req);
        if(ROCKETMQ_MSG_DISPATCH_PATH.equals(uri)) {
            handleRocketMQMessage(req, (HttpServletResponse) response);
            return;
        }

        try {
            chain.doFilter(request, response);
        } finally {
            ServiceGroupContext.removeGroupKey();
        }
    }

    private void handleRocketMQMessage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        byte[] bs = IOUtils.toByteArray(req.getInputStream());
        RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask task =
                DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(bs);
        task.setApplicationContext(applicationContext);

        Object obj = task.call();

        byte[] returnBs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(obj);
        IOUtils.write(returnBs, resp.getOutputStream());
    }

    @Override
    public void destroy() {
        //do nothing
    }
}
