package cn.com.duibaboot.ext.autoconfigure.javaagent.common;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.StaticMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.ClassStaticMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

import static cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch.byName;
import static net.bytebuddy.matcher.ElementMatchers.any;

/**
 * 由于butebuddy的限制，一个method无法被aop两次，故这个类的存在是为了打破此限制
 */
public class RandomUtils3Instrumentation extends ClassStaticMethodsEnhancePluginDefine implements AgentPluginExtSpi {

    private static final String ENHANCE_CLASS = "org.apache.commons.lang3.RandomUtils";

    @Override
    public ClassMatch enhanceClass() {
        return byName(ENHANCE_CLASS);
    }

    @Override
    protected StaticMethodsInterceptPoint[] getStaticMethodsInterceptPoints() {
        return new StaticMethodsInterceptPoint[] { new StaticMethodsInterceptPoint() {

            @Override
            public ElementMatcher<MethodDescription> getMethodsMatcher() {
                //此处的方法需要为所有MethodsInterceptor的超集，然后在每个MethodsInterceptor内部判断只处理自己需要的方法
                return any();
            }

            @Override
            public String getMethodsInterceptor() {
                return getInterceptorClassNames("random-utils3-interceptor");
            }

            @Override
            public boolean isOverrideArgs() {
                //如果任意一个MethodsInterceptor需要修改参数，则此处需要为true
                return true;
            }
        } };
    }
}
