package cn.com.duibaboot.ext.autoconfigure.limiter;

import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limiter;
import feign.Feign;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;

import java.lang.reflect.Method;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-12-23 15:37
 * @descript: dubbo限流拦截器
 * @version: 1.0
 */
@Activate(group = CommonConstants.PROVIDER)
public class DubboLimiterFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {

        Class<?> interfaceInstance = invoker.getInterface();
        Method method;
        try {
            method = interfaceInstance.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
        } catch (NoSuchMethodException e) {
            // ignore
            return invoker.invoke(invocation);
        }

        String serverKey = Feign.configKey(interfaceInstance, method);
        Object limiter = ServerLimiterAutoConfiguration.getServerLimitRule(serverKey);
        if (limiter == null) {
            return invoker.invoke(invocation);
        }

        RpcException rateLimiterException = new RpcException(RpcException.LIMIT_EXCEEDED_EXCEPTION, "限流异常");
        if (limiter instanceof RateLimiter) {
            RateLimiter rateLimiter = (RateLimiter) limiter;
            if (!rateLimiter.tryAcquire()) {
                throw rateLimiterException;
            }

            return invoker.invoke(invocation);
        }

        Limiter<Void> vegasLimiter = (Limiter) limiter;
        Limiter.Listener listener = vegasLimiter.acquire(null).orElseThrow(() -> rateLimiterException);
        Result result = invoker.invoke(invocation);
        if (result.hasException()) {
            listener.onIgnore();
        } else {
            listener.onSuccess();
        }

        return result;
    }
}
