package cn.com.duibaboot.ext.autoconfigure.limiter;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.etcd.EtcdAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limit.VegasLimit;
import com.netflix.concurrency.limits.limiter.SimpleLimiter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

import javax.annotation.Resource;
import javax.servlet.Filter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-12-30 20:18
 * @descript: 同步限流配置
 * @version: 1.0
 */
@Slf4j
@Configuration
@AutoConfigureAfter(EtcdAutoConfiguration.class)
public class ServerLimiterAutoConfiguration {

    @Value("${spring.application.name}")
    private String currentAppName;

    @Resource
    private EtcdKVClientDelegate etcdKVClientDelegate;

    private final static Map<String, Object> serverLimitRuleMap = Maps.newConcurrentMap();

    public static Object getServerLimitRule(String server) {
        return serverLimitRuleMap.get(server);
    }

    @EventListener(MainContextRefreshedEvent.class)
    public void initLimitRule() {
        this.loadLimiterRule();
    }

    @EventListener(EnvironmentChangeEvent.class)
    public void listenLimitRule() {
        this.loadLimiterRule();
    }

    private void loadLimiterRule() {

        if (StringUtils.isBlank(currentAppName)) {
            log.info("没有获取到当前应用的名称，限流初始化失败");
            return;
        }

        Map<String, String> appLimiterMap = etcdKVClientDelegate.getWithPrefix(String.format("/config/%s/server.limit.rule", currentAppName));
        if (appLimiterMap == null) {
            return;
        }

        for (Map.Entry<String, String> entry : appLimiterMap.entrySet()) {

            List<String> splitters = Splitter.on("/").splitToList(entry.getKey());
            ServerLimiterDo serverLimiterDo = JSON.parseObject(entry.getValue(), ServerLimiterDo.class);
            serverLimitRuleMap.put(splitters.get(4), this.buildLimiter(serverLimiterDo));
        }
    }

    private Object buildLimiter(ServerLimiterDo serverLimiterDo) {

        if (serverLimiterDo.getLimitType() == ServerLimiterConstant.QPS) {
            return RateLimiter.create(serverLimiterDo.getLimitValue());
        }

        Limit limit = VegasLimit.newDefault();
        return SimpleLimiter.newBuilder().limit(limit).build();
    }

    public static void main(String[] args) throws Throwable {
//        Filter filter = new ConcurrencyLimitServletFilter(new ServletLimiterBuilder()
//                .partitionByUserPrincipal(principal -> principalToGroup.get(principal.getName())
//                        .partition("live", 0.9)
//                        .partition("batch", 0.1))
//                .build());

        //TODO 改变initialLimit
        Limit limit = VegasLimit.newBuilder().initialLimit(1).build();
        final SimpleLimiter<Void> limiter = SimpleLimiter.newBuilder().limit(limit).build();
        ThreadPoolExecutor es = (ThreadPoolExecutor)Executors.newFixedThreadPool(100);
        AtomicInteger sl = new AtomicInteger(10);
        for(int i=0;i<10;i++){
            final int j = i ;
            es.submit(new Runnable() {
                @Override
                public void run() {
                    int i=0;
                    while(true) {
                        try {
                            Limiter.Listener listener = limiter.acquire(null).orElseThrow(RateLimiterException::new);
                            try {
                                Thread.sleep(sl.get());
                            }
                            catch (InterruptedException e) {
                            }
                            listener.onIgnore();//TODO 改成onIgnore
                            i++;
                            if (i % 1000 == 0) {
                                System.out.println(j + "---" + i);
                            }
                        }catch(Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }

        while(true) {
            Thread.sleep(10000);
            sl.getAndAdd(100);
        }

//        listener.onSuccess();
//        listener.onDropped();
    }

}
