/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthRedisPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.tracer.isTracing() || !this.tracer.getCurrentSpan().isExportable()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Span span = this.tracer.createSpan("redis:/" + methodName);
        try {
            if (span.isExportable()) {
                span.tag("redis.op", methodName);
                span.tag("lc", "redisClient");
                span.tag("peer.service", "redis");
                span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("thread", Thread.currentThread().getName());
                if ("get".equals(methodName) && joinPoint.getArgs() != null && joinPoint.getArgs().length == 1 && joinPoint.getArgs()[0] != null) {
                    span.tag("redis.key", joinPoint.getArgs()[0].toString());
                }
            }
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }
}

