/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix.ThreadSafeHttpServletResponseWrapper;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;

public class HystrixStreamEndpointPostProcessor
implements SpecifiedBeanPostProcessor<HystrixStreamEndpoint> {
    @Override
    public Class<HystrixStreamEndpoint> getBeanType() {
        return HystrixStreamEndpoint.class;
    }

    @Override
    public Object postProcessBeforeInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget((Object)bean);
        factory.addAdvice((Advice)new HystrixStreamEndpointMethodInterceptor());
        return factory.getProxy();
    }

    public int getOrder() {
        return 0;
    }

    static class HystrixStreamEndpointMethodInterceptor
    implements MethodInterceptor {
        HystrixStreamEndpointMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("handle")) {
                Object[] args = invocation.getArguments();
                HttpServletResponse resp = (HttpServletResponse)args[1];
                args[1] = new ThreadSafeHttpServletResponseWrapper(resp);
            }
            return invocation.proceed();
        }
    }
}

