/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;

public class DuibaDataSourceMonitor
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DuibaDataSourceMonitor.class);
    private boolean initted = false;
    private Map<String, BasicDataSource> dataSourceMap;
    private Map<String, PerfTestRoutingDataSource> routingDataSourceMap;
    private Thread duibaDataSourceMonitorThread;
    private static final long RETENTION_TIME = 1800000L;
    private Map<String, Map<Long, MonitorObj>> secondMonitorMap = new ConcurrentHashMap<String, Map<Long, MonitorObj>>();

    protected synchronized String getSecondMonitorJson() {
        return JSON.toJSONString(this.secondMonitorMap);
    }

    public synchronized void startMonitorThread(ApplicationContext context) {
        if (!this.initted) {
            this.initted = true;
            this.dataSourceMap = context.getBeansOfType(BasicDataSource.class);
            this.routingDataSourceMap = context.getBeansOfType(PerfTestRoutingDataSource.class);
            if (this.dataSourceMap.isEmpty() && this.routingDataSourceMap.isEmpty()) {
                return;
            }
            this.duibaDataSourceMonitorThread = new Thread(() -> this.scanDataSources(), "duibaDataSourceMonitorThread");
            this.duibaDataSourceMonitorThread.start();
        }
    }

    private void scanDataSources() {
        while (true) {
            try {
                do {
                    for (Map.Entry<String, BasicDataSource> entry : this.dataSourceMap.entrySet()) {
                        this.scanDataSource(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : this.routingDataSourceMap.entrySet()) {
                        this.scanDataSource(entry.getKey(), ((PerfTestRoutingDataSource)entry.getValue()).getOriginalDataSource());
                        this.scanDataSource(entry.getKey() + "_shade", ((PerfTestRoutingDataSource)entry.getValue()).getShadeDataSource());
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } while (!Thread.currentThread().isInterrupted());
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    private synchronized void scanDataSource(String key, BasicDataSource ds) {
        if (ds != null && !ds.isClosed()) {
            int numIdleConnections = ds.getNumIdle();
            int numActiveConnections = ds.getNumActive();
            int maxTotal = ds.getMaxTotal();
            LinkedHashMap<Long, MonitorObj> dbSecondMonitorMap = this.secondMonitorMap.get(key);
            if (dbSecondMonitorMap == null) {
                dbSecondMonitorMap = new LinkedHashMap<Long, MonitorObj>(){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Long, MonitorObj> eldest) {
                        return eldest.getKey() < System.currentTimeMillis() - 1800000L;
                    }
                };
                this.secondMonitorMap.putIfAbsent(key, (Map<Long, MonitorObj>)dbSecondMonitorMap);
            }
            dbSecondMonitorMap.put(System.currentTimeMillis(), new MonitorObj(numIdleConnections, numActiveConnections, maxTotal));
        }
    }

    public List<DataSourceConfig> getDataSourceConfig() {
        BasicDataSource ds;
        ArrayList<DataSourceConfig> dataSourceConfigs = new ArrayList<DataSourceConfig>();
        for (Map.Entry<String, BasicDataSource> entry : this.dataSourceMap.entrySet()) {
            ds = entry.getValue();
            if (ds == null) continue;
            dataSourceConfigs.add(new DataSourceConfig(entry.getKey(), ds.getUrl(), ds.getUsername(), ds.getMaxTotal(), ds.getInitialSize(), ds.getMaxIdle(), ds.getMinIdle(), ds.getMaxWaitMillis()));
        }
        for (Map.Entry<String, Object> entry : this.routingDataSourceMap.entrySet()) {
            BasicDataSource prds;
            ds = ((PerfTestRoutingDataSource)entry.getValue()).getOriginalDataSource();
            if (ds != null) {
                dataSourceConfigs.add(new DataSourceConfig(entry.getKey(), ds.getUrl(), ds.getUsername(), ds.getMaxTotal(), ds.getInitialSize(), ds.getMaxIdle(), ds.getMinIdle(), ds.getMaxWaitMillis()));
            }
            if ((prds = ((PerfTestRoutingDataSource)entry.getValue()).getShadeDataSource()) == null) continue;
            dataSourceConfigs.add(new DataSourceConfig(entry.getKey() + "_shade", prds.getUrl(), prds.getUsername(), prds.getMaxTotal(), prds.getInitialSize(), prds.getMaxIdle(), prds.getMinIdle(), prds.getMaxWaitMillis()));
        }
        return dataSourceConfigs;
    }

    public synchronized void destroy() throws Exception {
        if (this.duibaDataSourceMonitorThread != null) {
            this.duibaDataSourceMonitorThread.interrupt();
        }
    }

    public static class MonitorObj {
        private short numActive;
        private short numAllocated;
        private short maxTotal;

        public MonitorObj(int numIdleConnections, int numActiveConnections, int maxTotal) {
            this.numActive = (short)numActiveConnections;
            this.maxTotal = (short)maxTotal;
            this.numAllocated = (short)(numActiveConnections + numIdleConnections);
        }

        public MonitorObj() {
        }

        public short getNumActive() {
            return this.numActive;
        }

        public short getNumAllocated() {
            return this.numAllocated;
        }

        public short getMaxTotal() {
            return this.maxTotal;
        }
    }

    public static class DataSourceConfig {
        private String dataSourceName;
        private String url;
        private String username;
        private int maxTotal;
        private int initialSize;
        private int maxIdle;
        private int minIdle;
        private long maxWaitMillis;

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUsername() {
            return this.username;
        }

        public int getMaxTotal() {
            return this.maxTotal;
        }

        public int getInitialSize() {
            return this.initialSize;
        }

        public int getMaxIdle() {
            return this.maxIdle;
        }

        public int getMinIdle() {
            return this.minIdle;
        }

        public long getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
        }

        public void setInitialSize(int initialSize) {
            this.initialSize = initialSize;
        }

        public void setMaxIdle(int maxIdle) {
            this.maxIdle = maxIdle;
        }

        public void setMinIdle(int minIdle) {
            this.minIdle = minIdle;
        }

        public void setMaxWaitMillis(long maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSourceConfig)) {
                return false;
            }
            DataSourceConfig other = (DataSourceConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataSourceName = this.getDataSourceName();
            String other$dataSourceName = other.getDataSourceName();
            if (this$dataSourceName == null ? other$dataSourceName != null : !this$dataSourceName.equals(other$dataSourceName)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (this.getMaxTotal() != other.getMaxTotal()) {
                return false;
            }
            if (this.getInitialSize() != other.getInitialSize()) {
                return false;
            }
            if (this.getMaxIdle() != other.getMaxIdle()) {
                return false;
            }
            if (this.getMinIdle() != other.getMinIdle()) {
                return false;
            }
            return this.getMaxWaitMillis() == other.getMaxWaitMillis();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSourceConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataSourceName = this.getDataSourceName();
            result = result * 59 + ($dataSourceName == null ? 43 : $dataSourceName.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + this.getMaxTotal();
            result = result * 59 + this.getInitialSize();
            result = result * 59 + this.getMaxIdle();
            result = result * 59 + this.getMinIdle();
            long $maxWaitMillis = this.getMaxWaitMillis();
            result = result * 59 + (int)($maxWaitMillis >>> 32 ^ $maxWaitMillis);
            return result;
        }

        public String toString() {
            return "DuibaDataSourceMonitor.DataSourceConfig(dataSourceName=" + this.getDataSourceName() + ", url=" + this.getUrl() + ", username=" + this.getUsername() + ", maxTotal=" + this.getMaxTotal() + ", initialSize=" + this.getInitialSize() + ", maxIdle=" + this.getMaxIdle() + ", minIdle=" + this.getMinIdle() + ", maxWaitMillis=" + this.getMaxWaitMillis() + ")";
        }

        public DataSourceConfig() {
        }

        public DataSourceConfig(String dataSourceName, String url, String username, int maxTotal, int initialSize, int maxIdle, int minIdle, long maxWaitMillis) {
            this.dataSourceName = dataSourceName;
            this.url = url;
            this.username = username;
            this.maxTotal = maxTotal;
            this.initialSize = initialSize;
            this.maxIdle = maxIdle;
            this.minIdle = minIdle;
            this.maxWaitMillis = maxWaitMillis;
        }
    }
}

