/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dns;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import sun.net.spi.nameservice.NameService;

@Configuration
@ConditionalOnProperty(value={"duiba.dns.cache.enabled"}, havingValue="true", matchIfMissing=false)
public class DnsCacheAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DnsCacheAutoConfiguration.class);

    @PostConstruct
    public void init() {
        try {
            Class.forName("java.net.InetAddress");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Field field = InetAddress.class.getDeclaredField("nameServices");
            field.setAccessible(true);
            List nameServices = (List)field.get(null);
            ArrayList<CachedNameServiceWrapper> nameServicesNew = new ArrayList<CachedNameServiceWrapper>();
            for (NameService nameService : nameServices) {
                nameServicesNew.add(new CachedNameServiceWrapper(nameService));
            }
            int i = 0;
            for (NameService nameService : nameServicesNew) {
                nameServices.set(i++, nameService);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.warn("\u66ff\u6362DNS\u89e3\u6790\u5668\u5931\u8d25\uff01\uff0c\u8c8c\u4f3cJDK\u65b0\u7248\u672c\u6539\u53d8\u4e86\uff1f", (Throwable)e);
        }
    }

    private static final class CachedNameServiceWrapper
    implements NameService {
        private static final ThreadPoolExecutor executorService = new ThreadPoolExecutor(1, 20, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("DnsResolve", true), new ThreadPoolExecutor.CallerRunsPolicy());
        private LoadingCache<String, InetAddress[]> dnsCache;
        private NameService delegate;

        public CachedNameServiceWrapper(NameService delegate) {
            this.delegate = delegate;
            this.dnsCache = Caffeine.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.SECONDS).maximumSize(10000L).initialCapacity(1000).executor((Executor)executorService).build(key -> delegate.lookupAllHostAddr(key));
        }

        public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            try {
                return (InetAddress[])this.dnsCache.get((Object)host);
            }
            catch (CompletionException e) {
                if (e.getCause() != null && e.getCause() instanceof UnknownHostException) {
                    throw (UnknownHostException)e.getCause();
                }
                if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        public String getHostByAddr(byte[] bytes) throws UnknownHostException {
            return this.delegate.getHostByAddr(bytes);
        }

        static {
            executorService.allowCoreThreadTimeOut(true);
        }
    }
}

