/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.HeaderBasedMessagingInjector;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.instrument.messaging.TraceSpanMessagingAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Tracer.class})
@AutoConfigureBefore(value={TraceSpanMessagingAutoConfiguration.class})
@EnableConfigurationProperties(value={TraceKeys.class})
public class DuibaTraceSpanMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapExtractor messagingSpanExtractor() {
        return new HeaderBasedMessagingExtractor();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessagingSpanTextMapInjector messagingSpanInjector(TraceKeys traceKeys) {
        return new HeaderBasedMessagingInjector(traceKeys);
    }
}

