/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;

@Aspect
public class SleuthJestElasticSearchPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* io.searchbox.client.JestClient.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (!this.tracer.isTracing()) {
            return joinPoint.proceed();
        }
        if (!"execute".equals(methodName) && !"executeAsync".equals(methodName)) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.createSpan("elasticsearch:/" + methodName);
        try {
            if (span.isExportable()) {
                span.tag("elasticsearch.class_method", "JestClient." + methodName);
                span.tag("lc", "Jest");
                span.tag("peer.service", "Elasticsearch");
                span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("thread", Thread.currentThread().getName());
            }
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }
}

