/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import com.alibaba.ttl.TtlCallable;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import java.util.concurrent.Callable;

public class CustomHystrixConcurrencyStrategy
extends HystrixConcurrencyStrategy {
    public <T> Callable<T> wrapCallable(Callable<T> callable) {
        return new CallableWrapper((Callable)TtlCallable.get(callable));
    }

    private static class CallableWrapper
    implements Callable {
        private Callable callable;
        private RpcContext rpcContext = RpcContext.getContext().clone();
        private Integer currentThreshold = DBTimeProfile.getCurrentThreshold();

        public CallableWrapper(Callable callable) {
            this.callable = callable;
        }

        public Object call() throws Exception {
            RpcContext.setContext(this.rpcContext);
            try {
                if (this.currentThreshold != null) {
                    DBTimeProfile.setCurrentThreshold((int)this.currentThreshold);
                }
                DBTimeProfile.start();
                Object v = this.callable.call();
                return v;
            }
            finally {
                RpcContext.removeContext();
                DBTimeProfile.end((String)Thread.currentThread().getName());
            }
        }
    }
}

