/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;

public class ThreadSafeHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private PrintWriter delegateWriter;

    public ThreadSafeHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public synchronized PrintWriter getWriter() throws IOException {
        if (this.delegateWriter == null) {
            PrintWriter writer = super.getWriter();
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget((Object)writer);
            factory.addAdvice((Advice)new PrintWriterMethodInterceptor());
            this.delegateWriter = (PrintWriter)factory.getProxy();
        }
        return this.delegateWriter;
    }

    static class PrintWriterMethodInterceptor
    implements MethodInterceptor {
        private volatile boolean errorOccurred;

        PrintWriterMethodInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            PrintWriter originalWriter = (PrintWriter)invocation.getThis();
            if (methodName.equals("print") || methodName.equals("write") || methodName.equals("println")) {
                PrintWriter printWriter = originalWriter;
                synchronized (printWriter) {
                    Object obj = invocation.proceed();
                    this.errorOccurred = originalWriter.checkError();
                    originalWriter.flush();
                    return obj;
                }
            }
            if (methodName.equals("checkError")) {
                return this.errorOccurred;
            }
            if (methodName.equals("flush")) {
                return null;
            }
            return invocation.proceed();
        }
    }
}

