/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.data.redis;

import cn.com.duibaboot.ext.autoconfigure.data.redis.RedisProperties;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class JedisConnectionFactoryBean
implements FactoryBean<JedisConnectionFactory> {
    @Resource
    private RedisProperties redisProperties;
    private String extraRedisTemplateIdPrefix;

    public JedisConnectionFactoryBean(String extraRedisTemplateIdPrefix) {
        this.extraRedisTemplateIdPrefix = extraRedisTemplateIdPrefix;
    }

    private RedisProperties getRedisProperties() {
        if (this.extraRedisTemplateIdPrefix == null) {
            return this.redisProperties;
        }
        return this.redisProperties.getExtra().get(this.extraRedisTemplateIdPrefix);
    }

    public JedisConnectionFactory getObject() throws Exception {
        JedisConnectionFactory f = this.applyProperties(this.createJedisConnectionFactory());
        f.afterPropertiesSet();
        return f;
    }

    public Class<?> getObjectType() {
        return JedisConnectionFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private JedisConnectionFactory createJedisConnectionFactory() {
        JedisPoolConfig poolConfig;
        JedisPoolConfig jedisPoolConfig = poolConfig = this.getRedisProperties().getPool() != null ? this.jedisPoolConfig() : new JedisPoolConfig();
        if (this.getSentinelConfig() != null) {
            return new JedisConnectionFactory(this.getSentinelConfig(), poolConfig);
        }
        if (this.getClusterConfiguration() != null) {
            return new JedisConnectionFactory(this.getClusterConfiguration(), poolConfig);
        }
        return new JedisConnectionFactory(poolConfig);
    }

    private JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        RedisProperties.Pool props = this.getRedisProperties().getPool();
        config.setMaxTotal(props.getMaxActive());
        config.setMaxIdle(props.getMaxIdle());
        config.setMinIdle(props.getMinIdle());
        config.setMaxWaitMillis((long)props.getMaxWait());
        config.setTestWhileIdle(true);
        config.setTimeBetweenEvictionRunsMillis(90000L);
        config.setSoftMinEvictableIdleTimeMillis(180000L);
        config.setMinEvictableIdleTimeMillis(-1L);
        config.setNumTestsPerEvictionRun(-1);
        return config;
    }

    protected final JedisConnectionFactory applyProperties(JedisConnectionFactory factory) {
        factory.setHostName(this.getRedisProperties().getHost());
        factory.setPort(this.getRedisProperties().getPort());
        if (this.getRedisProperties().getPassword() != null) {
            factory.setPassword(this.getRedisProperties().getPassword());
        }
        if (this.getRedisProperties().isSsl()) {
            factory.setUseSsl(true);
        }
        factory.setDatabase(this.getRedisProperties().getDatabase());
        if (this.getRedisProperties().getTimeout() > 0) {
            factory.setTimeout(this.getRedisProperties().getTimeout());
        }
        return factory;
    }

    protected final RedisSentinelConfiguration getSentinelConfig() {
        RedisProperties.Sentinel sentinelProperties = this.getRedisProperties().getSentinel();
        if (sentinelProperties != null) {
            RedisSentinelConfiguration config = new RedisSentinelConfiguration();
            config.master(sentinelProperties.getMaster());
            config.setSentinels(this.createSentinels(sentinelProperties));
            return config;
        }
        return null;
    }

    protected final RedisClusterConfiguration getClusterConfiguration() {
        if (this.getRedisProperties().getCluster() == null) {
            return null;
        }
        RedisProperties.Cluster clusterProperties = this.getRedisProperties().getCluster();
        RedisClusterConfiguration config = new RedisClusterConfiguration(clusterProperties.getNodes());
        if (clusterProperties.getMaxRedirects() != null) {
            config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
        }
        return config;
    }

    private List<RedisNode> createSentinels(RedisProperties.Sentinel sentinel) {
        ArrayList<RedisNode> sentinels = new ArrayList<RedisNode>();
        String nodes = sentinel.getNodes();
        for (String node : StringUtils.commaDelimitedListToStringArray((String)nodes)) {
            try {
                String[] parts = StringUtils.split((String)node, (String)":");
                Assert.state((parts.length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
                sentinels.add(new RedisNode(parts[0], Integer.valueOf(parts[1]).intValue()));
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
            }
        }
        return sentinels;
    }
}

