/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import com.google.common.base.Joiner;
import io.elasticjob.lite.internal.monitor.MonitorService;
import io.elasticjob.lite.internal.schedule.JobRegistry;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.util.ReflectionUtils;

public class ElasticJobMonitorEndpointV3
extends AbstractEndpoint<String> {
    public ElasticJobMonitorEndpointV3() {
        super("elasticJobMonitor");
    }

    public String invoke() {
        return this.genFromElasticJob3();
    }

    public String genFromElasticJob3() {
        JobRegistry jobRegistry = JobRegistry.getInstance();
        Field regCenterMapField = ReflectionUtils.findField(jobRegistry.getClass(), (String)"regCenterMap");
        regCenterMapField.setAccessible(true);
        Map regCenterMap = (Map)ReflectionUtils.getField((Field)regCenterMapField, (Object)jobRegistry);
        Method dumpDirectlyMethod = ReflectionUtils.findMethod(MonitorService.class, (String)"dumpDirectly", (Class[])new Class[]{String.class, List.class});
        dumpDirectlyMethod.setAccessible(true);
        StringBuilder sb = new StringBuilder();
        regCenterMap.forEach((jobName, regCenter) -> {
            MonitorService ms = new MonitorService(regCenter, jobName);
            ArrayList result = new ArrayList();
            ReflectionUtils.invokeMethod((Method)dumpDirectlyMethod, (Object)ms, (Object[])new Object[]{"/" + jobName, result});
            String jobMonitorData = Joiner.on((String)"\n").join(result);
            sb.append("----").append("jobName:").append((String)jobName).append("----\n").append(jobMonitorData).append("\n");
        });
        return sb.toString();
    }
}

