/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.span;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.span.SpanType;
import com.alibaba.fastjson.JSON;
import com.google.gson.JsonElement;

public class MybatisFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = -3291559479699581758L;
    private String mappedStatementId;
    private String parameterType;
    private byte[] parameterValue;
    private Object parameterValueJson;
    private String returnType;
    private byte[] returnValue;
    private Object returnValueJson;

    @Override
    public SpanType getSpanType() {
        return SpanType.MYBATIS;
    }

    public static MybatisFlowReplaySpan createSpan(String mappedStatementId, Object parameter) {
        MybatisFlowReplaySpan span = new MybatisFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.setMappedStatementId(mappedStatementId);
        if (parameter != null) {
            span.setParameterType(parameter.getClass().getName());
            span.setParameterValue(parameter);
        }
        return span;
    }

    public void setRet(Object ret) {
        this.setReturnType(ret != null ? ret.getClass().getName() : null);
        this.setReturnValue(ret);
    }

    @Override
    public void convertToDetail(String stackFrames) {
        super.convertToDetail(stackFrames);
        try {
            JsonElement pTemp = gson.toJsonTree(this.getParameterValue());
            this.parameterValueJson = JSON.parse((String)pTemp.toString());
        }
        catch (Exception e) {
            this.parameterValueJson = e.toString();
        }
        try {
            JsonElement rTemp = gson.toJsonTree(this.getReturnValue());
            this.returnValueJson = JSON.parse((String)rTemp.toString());
        }
        catch (Exception e) {
            this.returnValueJson = e.toString();
        }
        this.parameterValue = null;
        this.returnValue = null;
    }

    public String getMappedStatementId() {
        return this.mappedStatementId;
    }

    public void setMappedStatementId(String mappedStatementId) {
        this.mappedStatementId = mappedStatementId;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(String parameterType) {
        this.parameterType = parameterType;
    }

    public Object getParameterValue() {
        return KryoSerializer.deserialize(this.parameterValue);
    }

    public void setParameterValue(Object parameterValue) {
        this.parameterValue = KryoSerializer.serialize(parameterValue);
    }

    public Object getParameterValueJson() {
        return this.parameterValueJson;
    }

    public void setParameterValueJson(Object parameterValueJson) {
        this.parameterValueJson = parameterValueJson;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(this.returnValue);
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = KryoSerializer.serialize(returnValue);
    }

    public Object getReturnValueJson() {
        return this.returnValueJson;
    }

    public void setReturnValueJson(Object returnValueJson) {
        this.returnValueJson = returnValueJson;
    }
}

