/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ServiceGroupFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ServiceGroupFilter.class);
    public static final String ROCKETMQ_MSG_DISPATCH_PATH = "/bootext/serviceGroup/rocketmqMsgDispatch";
    @Resource
    private ApplicationContext applicationContext;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri;
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey((HttpServletRequest)request);
        HttpServletRequest req = (HttpServletRequest)request;
        if (groupKey == null && SpringEnvironmentUtils.isDevEnv()) {
            String ip = RequestTool.getIpAddr((HttpServletRequest)req);
            if (ip.equals("127.0.0.1")) {
                ip = NetUtils.getLocalIp();
            }
            groupKey = "dev_ip_" + ip;
        }
        if (StringUtils.isNotBlank((CharSequence)groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }
        if (ROCKETMQ_MSG_DISPATCH_PATH.equals(uri = RequestUtils.getRequestPath((HttpServletRequest)req))) {
            this.handleRocketMQMessage(req, (HttpServletResponse)response);
            return;
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            ServiceGroupContext.removeGroupKey();
        }
    }

    private void handleRocketMQMessage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        byte[] bs = IOUtils.toByteArray((InputStream)req.getInputStream());
        RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask task = (RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask)DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(bs);
        task.setApplicationContext(this.applicationContext);
        Object obj = task.call();
        byte[] returnBs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(obj);
        IOUtils.write((byte[])returnBs, (OutputStream)resp.getOutputStream());
    }

    public void destroy() {
    }
}

