/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.PluginException;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.OverrideCallable;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstMethodsInterWithOverrideArgs {
    private static final Logger logger = LoggerFactory.getLogger((String)InstMethodsInterWithOverrideArgs.class.getName());
    private List<InstanceMethodsAroundInterceptor> interceptors = new ArrayList<InstanceMethodsAroundInterceptor>();

    public InstMethodsInterWithOverrideArgs(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            String[] classNames;
            for (String className : classNames = instanceMethodsAroundInterceptorClassName.split(",")) {
                InstanceMethodsAroundInterceptor interceptor = (InstanceMethodsAroundInterceptor)InterceptorInstanceLoader.load(className, classLoader);
                this.interceptors.add(interceptor);
            }
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    @RuntimeType
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @Origin Method method, @Morph(defaultMethod=false) OverrideCallable zuper) throws Throwable {
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            for (InstanceMethodsAroundInterceptor interceptor : this.interceptors) {
                interceptor.beforeMethod(obj, method, allArguments, method.getParameterTypes(), result);
            }
        }
        catch (PluginException e) {
            throw e;
        }
        catch (Throwable t) {
            logger.error("class[" + obj.getClass() + "] before method[" + method.getName() + "] intercept failure", t);
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                    InstanceMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                    interceptor.handleMethodException(obj, method, allArguments, method.getParameterTypes(), t);
                }
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Throwable t2) {
                logger.error("class[" + obj.getClass() + "] handle method[" + method.getName() + "] exception failure", t2);
            }
            throw t;
        }
        finally {
            try {
                for (int i = this.interceptors.size() - 1; i >= 0; --i) {
                    InstanceMethodsAroundInterceptor interceptor = this.interceptors.get(i);
                    ret = interceptor.afterMethod(zuper, obj, method, allArguments, method.getParameterTypes(), ret);
                }
            }
            catch (PluginException e) {
                throw e;
            }
            catch (Throwable t) {
                logger.error("class[" + obj.getClass() + "] after method[" + method.getName() + "] intercept failure", t);
            }
        }
        return ret;
    }
}

