/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.policy.AbortPolicyWithReport;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ScheduledThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.ProfileCallable;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.ProfileRunnable;
import com.alibaba.ttl.TtlCallable;
import com.alibaba.ttl.TtlRunnable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ReflectionUtils;

public class ThreadPoolExecutorWrapper
extends ThreadPoolTaskExecutor
implements AsyncTaskExecutor,
ExecutorService,
SmartLifecycle {
    private final ThreadPoolProperties poolProperties;
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutorWrapper.class);

    public ThreadPoolExecutorWrapper(String threadPoolName, ThreadPoolProperties poolProperties) {
        this.poolProperties = poolProperties;
        this.setThreadNamePrefix(threadPoolName);
        Objects.requireNonNull(threadPoolName);
        Objects.requireNonNull(poolProperties);
        this.setRejectedExecutionHandler(new AbortPolicyWithReport());
        this.setThreadFactory((ThreadFactory)new NamedThreadFactory(threadPoolName));
        this.setCorePoolSize(poolProperties.getCoreSize());
        this.setMaxPoolSize(Math.max(poolProperties.getMaxSize(), poolProperties.getCoreSize()));
        this.setQueueCapacity(poolProperties.getQueueSize());
    }

    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (this.poolProperties instanceof ScheduledThreadPoolProperties) {
            ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(this.poolProperties.getCoreSize(), threadFactory, rejectedExecutionHandler);
            Field f = ReflectionUtils.findField(ThreadPoolTaskExecutor.class, (String)"threadPoolExecutor");
            f.setAccessible(true);
            ReflectionUtils.setField((Field)f, (Object)this, (Object)pool);
            return pool;
        }
        return super.initializeExecutor(threadFactory, rejectedExecutionHandler);
    }

    public void shutdownGracefully() {
        this.getThreadPoolExecutor().shutdown();
        Long shutdownTimeout = this.poolProperties.getShutdownTimeout();
        try {
            this.getThreadPoolExecutor().awaitTermination(shutdownTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.error("", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.getThreadPoolExecutor().isShutdown()) {
            log.warn("\u7ebf\u7a0b\u6c60\u8d85\u8fc7{}ms\u4ecd\u672a\u5173\u95ed\uff0c\u5f3a\u5236\u5173\u95ed\u3002", (Object)this.poolProperties.getShutdownTimeout());
            this.getThreadPoolExecutor().shutdownNow();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.getThreadPoolExecutor().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.getThreadPoolExecutor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getThreadPoolExecutor().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getThreadPoolExecutor().awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.getThreadPoolExecutor().execute((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(command, this.getQueue(), this.getThreadPoolName(), this.poolProperties.getMaxWaitTimeMillis())));
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.getThreadPoolExecutor().submit(TtlCallable.get((Callable)new ProfileCallable(task, this.getQueue(), this.getThreadPoolName(), this.poolProperties.getMaxWaitTimeMillis())));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.getThreadPoolExecutor().submit((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.getThreadPoolName(), this.poolProperties.getMaxWaitTimeMillis())), result);
    }

    public void execute(Runnable task, long startTimeout) {
        this.getThreadPoolExecutor().execute((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.getThreadPoolName(), this.poolProperties.getMaxWaitTimeMillis())));
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.getThreadPoolExecutor().submit((Runnable)TtlRunnable.get((Runnable)new ProfileRunnable(task, this.getQueue(), this.getThreadPoolName(), this.poolProperties.getMaxWaitTimeMillis())));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.getThreadPoolExecutor().invokeAll(TtlCallable.gets(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getThreadPoolExecutor().invokeAll(TtlCallable.gets(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.getThreadPoolExecutor().invokeAny(TtlCallable.gets(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getThreadPoolExecutor().invokeAny(TtlCallable.gets(tasks), timeout, unit);
    }

    public boolean isTerminating() {
        return this.getThreadPoolExecutor().isTerminating();
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.getThreadPoolExecutor().getQueue();
    }

    public int getPoolSize() {
        return this.getThreadPoolExecutor().getPoolSize();
    }

    public int getCorePoolSize() {
        return this.getThreadPoolExecutor().getCorePoolSize();
    }

    public int getActiveCount() {
        return this.getThreadPoolExecutor().getActiveCount();
    }

    public int getLargestPoolSize() {
        return this.getThreadPoolExecutor().getLargestPoolSize();
    }

    public int getMaximumPoolSize() {
        return this.getThreadPoolExecutor().getMaximumPoolSize();
    }

    public long getTaskCount() {
        return this.getThreadPoolExecutor().getTaskCount();
    }

    public long getCompletedTaskCount() {
        return this.getThreadPoolExecutor().getCompletedTaskCount();
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(final Runnable callback) {
        new Thread(){

            @Override
            public void run() {
                try {
                    ThreadPoolExecutorWrapper.this.shutdownGracefully();
                }
                finally {
                    callback.run();
                }
            }
        }.start();
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return !this.getThreadPoolExecutor().isTerminating() && !this.getThreadPoolExecutor().isTerminated();
    }

    public int getPhase() {
        return -2;
    }

    public String getThreadPoolName() {
        return this.getThreadNamePrefix();
    }

    protected ThreadPoolExecutor getInnerThreadPoolExecutor() {
        return this.getThreadPoolExecutor();
    }

    public void destroy() {
    }
}

