package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;

import javax.servlet.http.HttpServletResponse;

/**
 * 这个类用于修复/hystrix.stream的bug：https://github.com/Netflix/Hystrix/issues/1756
 * <br/>
 * 对HttpServletResponse.PrintWriter的方法进行aop,从而进行必要的同步保护,以修复HystrixSampleSseServlet多线程往writer中写导致tomcat出错的问题。
 * <br/>
 * 等官方修复这个bug后可以去掉这个类。
 */
public class HystrixStreamEndpointPostProcessor implements SpecifiedBeanPostProcessor<HystrixStreamEndpoint> {
    @Override
    public Class<HystrixStreamEndpoint> getBeanType() {
        return HystrixStreamEndpoint.class;
    }

    @Override
    public Object postProcessBeforeInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(bean);
        factory.addAdvice(new HystrixStreamEndpointMethodInterceptor());
        return factory.getProxy();
    }

    @Override
    public int getOrder() {
        return 0;
    }

    static class HystrixStreamEndpointMethodInterceptor implements MethodInterceptor{

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if(methodName.equals("handle")){
                Object[] args = invocation.getArguments();
                HttpServletResponse resp = (HttpServletResponse)args[1];
                //把HttpServletResponse转换成经过包装的response
                args[1] = new ThreadSafeHttpServletResponseWrapper(resp);
            }

            return invocation.proceed();
        }
    }
}
