package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import org.apache.http.*;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.params.HttpParams;

import java.io.IOException;
import java.util.Locale;

/**
 * 包装一下 CloseableHttpResponse 让 HttpEntity.getContent()的流 可以被多次读取
 * 在引流回归中使用，可以在录制的时候读取一次，并且不影响客户端的读取
 * Created by guoyanfei .
 * 2019-07-22 .
 */
public class BufferedHttpResponseWapper implements CloseableHttpResponse {

    private final CloseableHttpResponse original;
    private final HttpEntity            buffer;

    public BufferedHttpResponseWapper(CloseableHttpResponse original) throws IOException {
        this.original = original;
        HttpEntity entity = original.getEntity();
        if (entity != null) {
            this.buffer = new BufferedHttpEntity(entity);
        } else {
            this.buffer = null;
        }
    }

    @Override
    public HttpEntity getEntity() {
        // BufferedHttpEntity 可以多次读取
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    @Override
    public StatusLine getStatusLine() {
        return this.original.getStatusLine();
    }

    @Override
    public void setStatusLine(StatusLine statusline) {
        this.original.setStatusLine(statusline);
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code) {
        this.original.setStatusLine(ver, code);
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.original.setStatusLine(ver, code, reason);
    }

    @Override
    public void setStatusCode(int code) throws IllegalStateException {
        this.original.setStatusCode(code);
    }

    @Override
    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.original.setReasonPhrase(reason);
    }

    @Override
    public void setEntity(HttpEntity entity) {
        this.original.setEntity(entity);
    }

    @Override
    public Locale getLocale() {
        return this.original.getLocale();
    }

    @Override
    public void setLocale(Locale loc) {
        this.original.setLocale(loc);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.original.getProtocolVersion();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.original.containsHeader(name);
    }

    @Override
    public Header[] getHeaders(String name) {
        return this.original.getHeaders(name);
    }

    @Override
    public Header getFirstHeader(String name) {
        return this.original.getFirstHeader(name);
    }

    @Override
    public Header getLastHeader(String name) {
        return this.original.getLastHeader(name);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.original.getAllHeaders();
    }

    @Override
    public void addHeader(Header header) {
        this.original.addHeader(header);
    }

    @Override
    public void addHeader(String name, String value) {
        this.original.addHeader(name, value);
    }

    @Override
    public void setHeader(Header header) {
        this.original.setHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        this.original.setHeader(name, value);
    }

    @Override
    public void setHeaders(Header[] headers) {
        this.original.setHeaders(headers);
    }

    @Override
    public void removeHeader(Header header) {
        this.original.removeHeader(header);
    }

    @Override
    public void removeHeaders(String name) {
        this.original.removeHeaders(name);
    }

    @Override
    public HeaderIterator headerIterator() {
        return this.original.headerIterator();
    }

    @Override
    public HeaderIterator headerIterator(String name) {
        return this.original.headerIterator(name);
    }

    @Override
    public HttpParams getParams() {
        return this.original.getParams();
    }

    @Override
    public void setParams(HttpParams params) {
        this.original.setParams(params);
    }
}
