package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.StepDiffColumn;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 回归请求参数类
 * Created by guoyanfei .
 * 2019-01-30 .
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ReplayConfigDto implements Serializable {

    private static final long serialVersionUID = -306367911536384839L;

    /**
     * 默认的回归线程池大小
     */
    private static final int DEFAULT_REPLAY_THREAD_POOL_SIZE = 10;

    /**
     * 报告id
     */
    private Long reportId;

    /**
     * 用例集文件地址
     */
    private String usecaseSetUrl;

    /**
     * 录制开始时间，用于把回归环境的时间设置成录制开始时间
     */
    private Long startTime;

    /**
     * 回归线程池大小
     */
    private Integer replayThreadPoolSize;

    /**
     * ip白名单，指定回归机器可以访问的ip
     */
    private List<String> ipWhitelist;

    /**
     * 屏蔽回归的接口列表
     */
    private List<String> maskedApis;

    /**
     * 屏蔽回归的用例列表
     */
    private List<String> maskedTraceIds;

    /**
     * 堆栈节点的前缀白名单
     * 每个span都有自己的调用链堆栈，其中很多内容是开发不需要关心的。
     * 一般情况下，开发关心的都是公司内部的一些包下面的调用
     * 比如 cn.com.duiba / cn.tuia 等等开头的行
     * 这个白名单的功能就是维护了公司内部的一些包的开头，用来过滤出开发需要关心的堆栈
     */
    private List<String> stackFramesPrefixWhitelist;

    /**
     * 中间步骤对比不一致map
     * key: traceId
     * value: 中间步骤对比不一致字段list
     */
    private Map<String, Set<StepDiffColumn>> maskedStepDiffColumnMap;

    public Integer getReplayThreadPoolSize() {
        if (replayThreadPoolSize == null || replayThreadPoolSize < 1) {
            return DEFAULT_REPLAY_THREAD_POOL_SIZE;
        }
        return replayThreadPoolSize;
    }

    /**
     * 参数是否合法
     * @return
     */
    public boolean isLegal() {
        return reportId != null && StringUtils.isNotBlank(usecaseSetUrl) && startTime != null && CollectionUtils.isNotEmpty(ipWhitelist);
    }

    public List<String> getIpWhitelist() {
        return ipWhitelist;
    }

}
