package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 查询回归结果的端点
 * Created by guoyanfei .
 * 2019-03-13 .
 */
@Slf4j
public class ReplayResultMvcEndpoint extends AbstractNamedMvcEndpoint {

    public ReplayResultMvcEndpoint() {
        super("flow/replay/result", "/flow/replay/result", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.GET)
    public String invoke(@RequestParam Long reportId) {
        JsonResult<JSONObject> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回归专用服务，无法进行回归相关操作");
            }
            // TODO 以下代码暂时注释掉，等测试稳定之后再放开，不然测试麻烦
//            if (!FlowReplayUtils.isReportIdValid(reportId)) {
//                throw new FlowReplayException("回归报告ID不合法");
//            }
            ReplayContext context = ReplayContextHolder.getReplayContext();
            if (context == null) {
                throw new FlowReplayException("回归未开始");
            }
            if (!reportId.equals(context.getReportId())) {
                throw new FlowReplayException("非法的报告ID");
            }
            JSONObject replayResult = new JSONObject();
            if (!ReplayContextHolder.isReplaying() && context.getReplayResult() != null) {
                replayResult.put("isEnded", true);
                replayResult.put("result", context.getReplayResult());
            } else {
                replayResult.put("isEnded", false);
                replayResult.put("result", null);
            }
            result = JsonResult.successResult(replayResult);
        } catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        } catch (Exception e) {
            log.error("回归查询结果异常", e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
