package cn.com.duibaboot.ext.autoconfigure.limiter;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.annotation.Resource;
import javax.servlet.Servlet;

/**
 * 限流拦截
 */
@Configuration
@ConditionalOnClass({Servlet.class, FeignClient.class})
@ConditionalOnWebApplication
@Import(SpringRpcLimterInterceptor.class)
public class SpringMvcConfigForLimiter extends WebMvcConfigurerAdapter implements Ordered {//WebMvcConfigurationSupport

    @Resource
    private SpringRpcLimterInterceptor springRpcLimterInterceptor;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(springRpcLimterInterceptor).addPathPatterns("/**");
    }

    @Override
    public int getOrder() {
        return -100;
    }
}
