package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorMediaTypes;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-22 19:41
 * @descript: 缓存状态拦截: /monitor/cache/all 获取所有缓存
 * @version: 1.0
 */
public class CacheMonitorMvcEndpoint extends AbstractNamedMvcEndpoint {


    public CacheMonitorMvcEndpoint() {
        super("monitor/cache", "/monitor/cache", true);
    }

    @ResponseBody
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    ActuatorMediaTypes.APPLICATION_ACTUATOR_V1_JSON_VALUE,
                    MediaType.APPLICATION_JSON_VALUE
            },
            value = "/{path}"
    )
    public Object invoke(@PathVariable String path, HttpServletRequest request) {


        if (path.equals("all")) {
            return CacheMonitorManager.getAllCache();
        }

        if (path.equals("query")) {
            return this.doQuery(request);
        }

        if (path.equals("record")) {
            return this.doRecord(request);
        }

        if (path.equals("clearAll")) {
            CacheMonitorManager.clearAllCacheValue();
            return Boolean.TRUE;
        }

        return "";
    }

    /**
     * 处理key查询
     *
     * @param servletRequest
     * @return
     */
    private Object doQuery(ServletRequest servletRequest) {

        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(cacheName)) {
            return "";
        }

        return CacheMonitorManager.getCacheValueByKey(cacheName, key);
    }

    /**
     * 处理key查询
     *
     * @param servletRequest
     * @return
     */
    private Object doRecord(ServletRequest servletRequest) {

        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        String page = servletRequest.getParameter("page");

        if (StringUtils.isBlank(page)) {
            page = "1";
        }

        RecordPagerResponse<CacheChangeRecord> records = CacheMonitorManager.getRecord(cacheName, key, Integer.parseInt(page));
        if (records == null) {
            return "";
        }

        return records;
    }
}
