package cn.com.duibaboot.ext.autoconfigure.perftest.filter;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="duiba.perftest.reject")
public class PerfTestRejectProperties {
    /**
     * 队列大小阈值,默认500，当servlet队列堆积数超过阈值时拒绝压测请求，当值小于0时关闭队列大小的检测
     */
    private int queueSizeThreshold = 500;

    /**
     * 繁忙线程数阈值，默认0.8，当servlet繁忙线程数超过阈值时拒绝压测请求
     */
    private float threadThreshold = 0.8f;

    /**
     * 熔断的阈值，默认20，当5秒内压测请求被拒绝超过指定次数时，接下来5秒内所有压测请求熔断
     */
    private int circuitBreakThreshold = 20;

    public float getThreadThreshold() {
        return threadThreshold;
    }

    public void setThreadThreshold(float threadThreshold) {
        this.threadThreshold = threadThreshold;
    }

    public int getQueueSizeThreshold() {
        return queueSizeThreshold;
    }

    public void setQueueSizeThreshold(int queueSizeThreshold) {
        this.queueSizeThreshold = queueSizeThreshold;
    }

    public int getCircuitBreakThreshold() {
        return circuitBreakThreshold;
    }

    public void setCircuitBreakThreshold(int circuitBreakThreshold) {
        this.circuitBreakThreshold = circuitBreakThreshold;
    }
}
