/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.ErrorParser;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.util.StringUtils;

@Aspect
public class SleuthRocketMqPlugin {
    private static final Logger log = LoggerFactory.getLogger(SleuthRocketMqPlugin.class);
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;
    @Autowired
    private SpanReporter spanReporter;
    @Autowired
    private MessagingSpanTextMapInjector messagingSpanTextMapInjector;
    @Autowired
    private MessagingSpanTextMapExtractor messagingSpanTextMapExtractor;

    @Around(value="execution(* org.apache.rocketmq.client.producer.DefaultMQProducer.send(..))")
    public Object rocketMqSendJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.tracer.isTracing()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof Message)) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.createSpan("rocketmq-send");
        try {
            Message msg = (Message)args[0];
            this.messagingSpanTextMapInjector.inject(span, (Object)new RocketMqRequestTextMap(msg));
            if (span.isExportable()) {
                span.tag("lc", "rocketmqProducer");
                span.tag("peer.service", "rocketmq");
                span.tag("rocketmq.topic", msg.getTopic());
                span.tag("rocketmq.tags", msg.getTags());
                span.tag("rocketmq.type", "send");
                span.tag("producer.isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("producer.thread", Thread.currentThread().getName());
                span.tag("producer.serviceGroupKey", ServiceGroupContext.getCurrentGroupKey());
            }
            span.logEvent("cs");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("cr");
            this.tracer.close(span);
        }
    }

    @Around(value="execution(* org.apache.rocketmq.client.consumer.listener.MessageListener*.consumeMessage(..))")
    public Object rocketMqConsumeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Object[] args = joinPoint.getArgs();
        if (args == null || args.length < 1 || args[0] == null || !(args[0] instanceof List)) {
            return joinPoint.proceed();
        }
        List list = (List)args[0];
        if (list == null || list.isEmpty() || !(list.get(0) instanceof MessageExt)) {
            return joinPoint.proceed();
        }
        MessageExt msg = (MessageExt)list.get(0);
        Span span = null;
        if (list.size() == 1 && (span = this.messagingSpanTextMapExtractor.joinTrace((Object)new RocketMqRequestTextMap((Message)msg))) != null) {
            span = this.tracer.createSpan("rocketmq-consume", span);
        }
        if (span == null) {
            span = this.tracer.createSpan("rocketmq-consume");
        }
        try {
            if (span.isExportable()) {
                span.tag("lc", "rocketmqConsumer");
                span.tag("peer.service", "rocketmq");
                span.tag("rocketmq.topic", msg.getTopic());
                span.tag("rocketmq.tags", msg.getTags());
                span.tag("rocketmq.type", "consume");
                span.tag("consumer.thread", Thread.currentThread().getName());
                span.tag("consumer.isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("consumer.serviceGroupKey", ServiceGroupContext.getCurrentGroupKey());
            }
            span.logEvent("sr");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.parseErrorTags(span, (Throwable)e);
            throw e;
        }
        finally {
            span.logEvent("ss");
            this.recordParentSpan(span);
            this.tracer.close(span);
        }
    }

    private void recordParentSpan(Span parent) {
        if (parent == null) {
            return;
        }
        if (parent.isRemote()) {
            if (log.isDebugEnabled()) {
                log.debug("Trying to send the parent span " + parent + " to Zipkin");
            }
            parent.stop();
            this.spanReporter.report(parent);
        }
    }

    class RocketMqRequestTextMap
    implements SpanTextMap {
        private final Message delegate;

        RocketMqRequestTextMap(Message delegate) {
            this.delegate = delegate;
        }

        public Iterator<Map.Entry<String, String>> iterator() {
            return Optional.ofNullable(this.delegate.getProperties()).orElse(Collections.emptyMap()).entrySet().iterator();
        }

        public void put(String key, String value) {
            if (!StringUtils.hasText((String)value)) {
                return;
            }
            this.addHeader(key, value);
        }

        private void addHeader(String key, String value) {
            this.delegate.putUserProperty(key, value);
        }
    }
}

