/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.ObjectToJsonStringConverter;
import feign.Feign;
import feign.MethodMetadata;
import feign.Param;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.netflix.feign.AnnotatedParameterProcessor;
import org.springframework.cloud.netflix.feign.support.SpringMvcContract;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class CustomSpringMvcContract
extends SpringMvcContract {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    public static final String HTTP_PARAMETER_PREFIX = "_p";
    public static final String HTTP_HEADER_PARAM_COLLECTION_SPLITTED = "Param-Collection-Splitted";
    private DuibaFeignProperties duibaFeignProperties;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final Map<String, Method> processedMethods = new HashMap<String, Method>();
    private final ConversionService object2jsonStringConversionService;
    private final Param.Expander object2jsonStringExpander;

    public CustomSpringMvcContract() {
        GenericConversionService cs = new GenericConversionService();
        cs.addConverter((GenericConverter)new ObjectToJsonStringConverter());
        this.object2jsonStringConversionService = cs;
        this.object2jsonStringExpander = new SpringMvcContract.ConvertingExpander(this.object2jsonStringConversionService);
    }

    public CustomSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors) {
        super(annotatedParameterProcessors);
        GenericConversionService cs = new GenericConversionService();
        cs.addConverter((GenericConverter)new ObjectToJsonStringConverter());
        this.object2jsonStringConversionService = cs;
        this.object2jsonStringExpander = new SpringMvcContract.ConvertingExpander(this.object2jsonStringConversionService);
    }

    public CustomSpringMvcContract(List<AnnotatedParameterProcessor> annotatedParameterProcessors, ConversionService conversionService, DuibaFeignProperties duibaFeignProperties) {
        super(annotatedParameterProcessors, conversionService);
        GenericConversionService cs = new GenericConversionService();
        cs.addConverter((GenericConverter)new ObjectToJsonStringConverter());
        this.object2jsonStringConversionService = cs;
        this.object2jsonStringExpander = new SpringMvcContract.ConvertingExpander(this.object2jsonStringConversionService);
        this.duibaFeignProperties = duibaFeignProperties;
    }

    public MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        this.processedMethods.put(Feign.configKey(targetType, (Method)method), method);
        return super.parseAndValidateMetadata(targetType, method);
    }

    protected void processAnnotationOnClass(MethodMetadata data, Class<?> clz) {
        super.processAnnotationOnClass(data, clz);
        if (clz.isAnnotationPresent(AdvancedFeignClient.class)) {
            Method method = this.processedMethods.get(data.configKey());
            if (!StringUtils.hasText((String)data.template().url())) {
                String pathValue = StringUtils.uncapitalize((String)clz.getSimpleName());
                data.template().insert(0, (CharSequence)pathValue);
            }
            this.processAdvancedFeignClientMethod(data, method);
        }
    }

    protected void processAnnotationOnMethod(MethodMetadata data, Annotation methodAnnotation, Method method) {
        if (method.getDeclaringClass().isAnnotationPresent(AdvancedFeignClient.class)) {
            return;
        }
        super.processAnnotationOnMethod(data, methodAnnotation, method);
    }

    protected boolean processAnnotationsOnParameter(MethodMetadata data, Annotation[] annotations, int paramIndex) {
        Method method = this.processedMethods.get(data.configKey());
        if (method.getDeclaringClass().isAnnotationPresent(AdvancedFeignClient.class)) {
            if (this.duibaFeignProperties.getSerializationEnum() != DuibaFeignProperties.DuibaFeignSerialization.JSON) {
                return true;
            }
            String parameterName = HTTP_PARAMETER_PREFIX + paramIndex;
            ArrayList<String> query = new ArrayList<String>();
            query.add(String.format("{%s}", parameterName));
            data.template().query(parameterName, query);
            ArrayList<String> names = data.indexToName().containsKey(paramIndex) ? (Collection)data.indexToName().get(paramIndex) : new ArrayList<String>();
            names.add(parameterName);
            data.indexToName().put(paramIndex, names);
            if (data.indexToExpander().get(paramIndex) == null && this.object2jsonStringConversionService.canConvert(method.getParameterTypes()[paramIndex], String.class)) {
                data.indexToExpander().put(paramIndex, this.object2jsonStringExpander);
            }
            return true;
        }
        return super.processAnnotationsOnParameter(data, annotations, paramIndex);
    }

    private void processAdvancedFeignClientMethod(MethodMetadata data, Method method) {
        Object[] methods;
        Object[] objectArray;
        RequestMapping methodMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        if (methodMapping == null) {
            RequestMethod[] requestMethodArray = new RequestMethod[1];
            objectArray = requestMethodArray;
            requestMethodArray[0] = RequestMethod.POST;
        } else {
            objectArray = methods = methodMapping.method();
        }
        if (methods.length == 0) {
            methods = new RequestMethod[]{RequestMethod.POST};
        }
        this.checkOne1(method, methods, "method");
        data.template().method(methods[0].name());
        if (methodMapping != null) {
            this.handleMethodMapping(method, methodMapping, data);
        } else {
            this.useMethodNameAsPath(data, method);
        }
        data.indexToExpander(new LinkedHashMap());
        if (this.duibaFeignProperties.getSerializationEnum() == DuibaFeignProperties.DuibaFeignSerialization.JSON) {
            data.template().header(HTTP_HEADER_PARAM_COLLECTION_SPLITTED, new String[]{"1"});
        } else {
            data.template().header("X-SERIAL", new String[]{this.duibaFeignProperties.getSerializationEnum().getType()});
            data.template().header(ACCEPT, new String[]{this.duibaFeignProperties.getSerializationEnum().getContentType()});
        }
    }

    private void handleMethodMapping(Method method, RequestMapping methodMapping, MethodMetadata data) {
        this.checkAtMostOne1(method, methodMapping.value(), "value");
        if (methodMapping.value().length > 0) {
            String pathValue = Util.emptyToNull((String)methodMapping.value()[0]);
            if (pathValue != null) {
                if (!(pathValue = this.resolve1(pathValue)).startsWith("/") && !data.template().toString().endsWith("/")) {
                    pathValue = "/" + pathValue;
                }
                data.template().append((CharSequence)pathValue);
            } else {
                this.useMethodNameAsPath(data, method);
            }
        } else {
            this.useMethodNameAsPath(data, method);
        }
        this.parseProduces1(data, method, methodMapping);
        this.parseConsumes1(data, method, methodMapping);
        this.parseHeaders1(data, method, methodMapping);
    }

    private void useMethodNameAsPath(MethodMetadata data, Method method) {
        String pathValue = method.getName();
        if (!data.template().toString().endsWith("/")) {
            pathValue = "/" + pathValue;
        }
        data.template().append((CharSequence)pathValue);
    }

    private void checkOne1(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && values.length == 1 ? 1 : 0) != 0, (String)"Method %s can only contain 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private void checkAtMostOne1(Method method, Object[] values, String fieldName) {
        Util.checkState((values != null && (values.length == 0 || values.length == 1) ? 1 : 0) != 0, (String)"Method %s can only contain at most 1 %s field. Found: %s", (Object[])new Object[]{method.getName(), fieldName, values == null ? null : Arrays.asList(values)});
    }

    private String resolve1(String value) {
        if (StringUtils.hasText((String)value) && this.resourceLoader instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)this.resourceLoader).getEnvironment().resolvePlaceholders(value);
        }
        return value;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    private void parseProduces1(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientAccepts;
        this.checkAtMostOne1(method, annotation.produces(), "produces");
        String[] serverProduces = annotation.produces();
        String string = clientAccepts = serverProduces.length == 0 ? null : Util.emptyToNull((String)serverProduces[0]);
        if (clientAccepts != null) {
            md.template().header(ACCEPT, new String[]{clientAccepts});
        }
    }

    private void parseConsumes1(MethodMetadata md, Method method, RequestMapping annotation) {
        String clientProduces;
        this.checkAtMostOne1(method, annotation.consumes(), "consumes");
        String[] serverConsumes = annotation.consumes();
        String string = clientProduces = serverConsumes.length == 0 ? null : Util.emptyToNull((String)serverConsumes[0]);
        if (clientProduces != null) {
            md.template().header(CONTENT_TYPE, new String[]{clientProduces});
        }
    }

    private void parseHeaders1(MethodMetadata md, Method method, RequestMapping annotation) {
        if (annotation.headers() != null && annotation.headers().length > 0) {
            for (String header : annotation.headers()) {
                int index = header.indexOf(61);
                md.template().header(this.resolve1(header.substring(0, index)), new String[]{this.resolve1(header.substring(index + 1).trim())});
            }
        }
    }
}

