/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.core.utils;

import cn.com.duiba.catmonitor.CatInstance;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.spi.MessageTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatUtils {
    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);
    private static final boolean IS_CAT_CLASS_EXISTS;

    private CatUtils() {
    }

    public static void completeTransaction(Transaction transaction) {
        if (logger.isDebugEnabled()) {
            MessageTree tree = Cat.getManager().getThreadLocalMessageTree();
            String messageId = tree.getMessageId();
            if (messageId == null) {
                messageId = Cat.createMessageId();
                tree.setMessageId(messageId);
            }
            CatUtils.printTransactionLog(transaction, tree);
        }
        transaction.complete();
    }

    private static void printTransactionLog(Transaction t, MessageTree tree) {
        if (logger.isDebugEnabled()) {
            logger.debug("mid:{},Cat_type:{},name:{},pid:{},rid:{},thread:{},created:{}", new Object[]{tree.getMessageId(), t.getType(), t.getName(), tree.getParentMessageId(), tree.getRootMessageId(), tree.getThreadName(), t.getTimestamp()});
        }
    }

    public static boolean isCatEnabled() {
        return CatUtils.isCatClassExists() && CatInstance.isEnable();
    }

    public static boolean isCatClassExists() {
        return IS_CAT_CLASS_EXISTS;
    }

    public static <T> T executeInCatTransaction(Callback<T> callback, String type, String name) throws Throwable {
        if (!CatUtils.isCatEnabled()) {
            return callback.invoke();
        }
        Transaction transaction = Cat.newTransaction((String)type, (String)name);
        try {
            T result = callback.invoke();
            transaction.setStatus("0");
            T t = result;
            return t;
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            transaction.setStatus(e);
            throw e;
        }
        finally {
            transaction.complete();
        }
    }

    static {
        boolean isCatClassExists = true;
        try {
            Class.forName("cn.com.duiba.catmonitor.CatInstance");
        }
        catch (ClassNotFoundException e) {
            isCatClassExists = false;
        }
        IS_CAT_CLASS_EXISTS = isCatClassExists;
    }

    public static interface Callback<R> {
        public R invoke() throws Throwable;
    }
}

