/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.dubbo;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"}, order=-10002)
public class DubboHystrixFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DubboHystrixFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        boolean isEnableHystrix = true;
        if (isEnableHystrix) {
            String remoteApplicationName = invoker.getUrl().getParameter("remote.application");
            String methodSignature = DubboHystrixFilter.configKey(invoker.getInterface(), invocation.getMethodName(), invocation.getParameterTypes());
            DubboHystrixCommand dubboHystrixCommand = new DubboHystrixCommand(invoker, invocation, remoteApplicationName, methodSignature);
            try {
                return (Result)dubboHystrixCommand.execute();
            }
            catch (HystrixBadRequestException e) {
                if (e.getCause() != null && e.getCause() instanceof RpcException) {
                    throw (RpcException)e.getCause();
                }
                throw e;
            }
        }
        return invoker.invoke(invocation);
    }

    private static String configKey(Class targetType, String methodName, Class<?>[] parameterTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(targetType.getSimpleName());
        builder.append('#').append(methodName).append('(');
        for (Class<?> param : parameterTypes) {
            builder.append(param.getSimpleName()).append(',');
        }
        if (parameterTypes.length > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.append(')').toString();
    }

    private static class DubboHystrixCommand
    extends HystrixCommand<Result> {
        private Invoker<?> invoker;
        private Invocation invocation;

        protected DubboHystrixCommand(Invoker<?> invoker, Invocation invocation, String group, String command) {
            super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)group)).andCommandKey(HystrixCommandKey.Factory.asKey((String)command)));
            this.invoker = invoker;
            this.invocation = invocation;
        }

        protected Result run() throws Exception {
            try {
                return this.invoker.invoke(this.invocation);
            }
            catch (RpcException e) {
                throw new HystrixBadRequestException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

