/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.etcd.config;

import cn.com.duibaboot.ext.autoconfigure.etcd.client.EtcdKVClientDelegate;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdConfigProperties;
import cn.com.duibaboot.ext.autoconfigure.etcd.config.EtcdPropertySource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class EtcdPropertySourceLocator
implements PropertySourceLocator {
    private final EtcdKVClientDelegate etcd;
    private final EtcdConfigProperties properties;

    public EtcdPropertySourceLocator(EtcdKVClientDelegate etcd, EtcdConfigProperties properties) {
        this.etcd = etcd;
        this.properties = properties;
    }

    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            CompositePropertySource composite;
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            ArrayList<String> contexts = new ArrayList<String>();
            this.setupContext(contexts, this.properties.getPrefix(), env.getProperty("spring.application.name"));
            if (env.getPropertySources().contains("etcd")) {
                composite = (CompositePropertySource)env.getPropertySources().get("etcd");
                composite.getPropertySources().clear();
            } else {
                composite = new CompositePropertySource("etcd");
            }
            Collections.reverse(contexts);
            for (String context : contexts) {
                EtcdPropertySource propertySource = new EtcdPropertySource(context, this.etcd, this.properties);
                propertySource.init();
                composite.addPropertySource((PropertySource)propertySource);
            }
            return composite;
        }
        return null;
    }

    private void setupContext(List<String> contexts, String prefix, String item) {
        String ctx = prefix + "/" + item;
        if (ctx.startsWith("/")) {
            ctx = ctx.substring(1);
        }
        contexts.add(ctx);
    }
}

