/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayConstants;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ParamComparator {
    private static final String EXPR_ROOT_OBJ = "_obj";
    private static final String EXPR_OBJ = "";
    private static final String EXPR_ROOT_ARRAY = "_obj[]";
    private static final String EXPR_ARRAY = "[]";
    private static final String EXPR_ARRAY_LENGTH = "_length";
    private static final String EXPR_ROOT_VALUE = "_value";
    private static final String EXPR_VALUE = "";
    private static final String EXPR_POINT = ".";

    public static CompareResult compareObject(Object recordVal, Object replayVal) {
        HashSet<DiffItem> diffItems = new HashSet<DiffItem>();
        ParamComparator.innerCompareObject(0, recordVal, replayVal, diffItems, null);
        return new CompareResult(diffItems);
    }

    public static CompareResult compareArray(Object[] recordArray, Object[] replayArray) {
        HashSet<DiffItem> diffItems = new HashSet<DiffItem>();
        if (recordArray != null && replayArray != null) {
            if (recordArray.length != replayArray.length) {
                DiffContext diffContext = DiffContext.buildArray(null, true);
                diffItems.add(new DiffItem(0, diffContext));
            } else {
                for (int i = 0; i < recordArray.length; ++i) {
                    ParamComparator.innerCompareObject(i, recordArray[i], replayArray[i], diffItems, null);
                }
            }
        } else if (recordArray != null || replayArray != null) {
            DiffContext diffContext = DiffContext.buildArray(null, false);
            diffItems.add(new DiffItem(0, diffContext));
        }
        return new CompareResult(diffItems);
    }

    private static void innerCompareObject(int paramIdx, Object recordVal, Object replayVal, Set<DiffItem> diffItems, DiffContext parentContext) {
        if (recordVal == null && replayVal == null) {
            return;
        }
        if (recordVal == null || replayVal == null) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
            return;
        }
        if (replayVal instanceof String && ((String)replayVal).contains("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%")) {
            return;
        }
        if (recordVal instanceof byte[] && replayVal instanceof byte[]) {
            if (((byte[])replayVal).length == 32 && "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(new String((byte[])replayVal))) {
                return;
            }
            if (!Objects.deepEquals(recordVal, replayVal)) {
                diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
            }
            return;
        }
        if (recordVal instanceof byte[][] && replayVal instanceof byte[][]) {
            byte[][] recordValArray = (byte[][])recordVal;
            byte[][] replayValArray = (byte[][])replayVal;
            if (recordValArray.length != replayValArray.length) {
                diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, true)));
                return;
            }
            for (int i = 0; i < replayValArray.length; ++i) {
                byte[] v = replayValArray[i];
                if (v.length == 32 && "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(new String(v)) || Objects.deepEquals(recordValArray[i], v)) continue;
                diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, false)));
                return;
            }
            return;
        }
        String recordJson = JSON.toJSONString((Object)recordVal);
        String replayJson = JSON.toJSONString((Object)replayVal);
        Object recordObj = JSON.parse((String)recordJson);
        Object replayObj = JSON.parse((String)replayJson);
        if (recordObj instanceof JSONArray && replayObj instanceof JSONArray) {
            ParamComparator.innerCompareJSONArray(paramIdx, (JSONArray)recordObj, (JSONArray)replayObj, diffItems, parentContext);
            return;
        }
        if (recordObj instanceof JSONObject && replayObj instanceof JSONObject) {
            ParamComparator.innerCompareJSONObject(paramIdx, (JSONObject)recordObj, (JSONObject)replayObj, diffItems, parentContext);
            return;
        }
        if (!recordObj.equals(replayObj)) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildValue(parentContext)));
        }
    }

    private static void innerCompareJSONArray(int paramIdx, JSONArray recordArray, JSONArray replayArray, Set<DiffItem> diffItems, DiffContext parentContext) {
        if (recordArray.size() != replayArray.size()) {
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, true)));
            return;
        }
        Iterator iterator = recordArray.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Object recordValue = iterator.next();
            Object replayValue = replayArray.get(i);
            if (!"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(replayValue)) {
                String recordValueStr = JSON.toJSONString(recordValue);
                if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                    String replayValueStr = replayValue != null ? JSON.toJSONString((Object)replayValue) : null;
                    ParamComparator.innerCompareObject(paramIdx, JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr), diffItems, DiffContext.buildArray(parentContext, false));
                } else if (!Objects.equals(recordValue, replayValue)) {
                    diffItems.add(new DiffItem(paramIdx, DiffContext.buildArray(parentContext, false)));
                }
            }
            ++i;
        }
    }

    private static void innerCompareJSONObject(int paramIdx, JSONObject recordObj, JSONObject replayObj, Set<DiffItem> diffItems, DiffContext parentContext) {
        for (Map.Entry entry : recordObj.entrySet()) {
            String replayValueStr;
            if (FlowReplayConstants.COLUMN_NAME_WHITELIST.contains(entry.getKey())) continue;
            Object recordValue = entry.getValue();
            Object replayValue = replayObj.get(entry.getKey());
            if ("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%".equals(replayValue)) continue;
            String recordValueStr = recordValue != null ? JSON.toJSONString(recordValue) : null;
            String string = replayValueStr = replayValue != null ? JSON.toJSONString((Object)replayValue) : null;
            if (FlowReplayUtils.isJSONValid(recordValueStr)) {
                ParamComparator.innerCompareObject(paramIdx, JSON.parse((String)recordValueStr), JSON.parse((String)replayValueStr), diffItems, DiffContext.buildObject(parentContext, (String)entry.getKey()));
                continue;
            }
            if (Objects.equals(recordValue, replayValue)) continue;
            diffItems.add(new DiffItem(paramIdx, DiffContext.buildObject(parentContext, (String)entry.getKey())));
        }
    }

    public static class DiffContext {
        private String columnPath;

        public static DiffContext buildValue(DiffContext parentContext) {
            String currentPath = parentContext == null ? ParamComparator.EXPR_ROOT_VALUE : "";
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

        public static DiffContext buildObject(DiffContext parentContext, String currentKey) {
            String currentPath = (parentContext == null ? ParamComparator.EXPR_ROOT_OBJ : "") + ParamComparator.EXPR_POINT + currentKey;
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

        public static DiffContext buildArray(DiffContext parentContext, boolean isLengthDiff) {
            String currentPath = (parentContext == null ? ParamComparator.EXPR_ROOT_ARRAY : ParamComparator.EXPR_ARRAY) + (isLengthDiff ? "._length" : "");
            DiffContext context = new DiffContext();
            context.columnPath = (parentContext != null ? parentContext.getColumnPath() : "") + currentPath;
            return context;
        }

        public String getColumnPath() {
            return this.columnPath;
        }

        public void setColumnPath(String columnPath) {
            this.columnPath = columnPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiffContext)) {
                return false;
            }
            DiffContext other = (DiffContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$columnPath = this.getColumnPath();
            String other$columnPath = other.getColumnPath();
            return !(this$columnPath == null ? other$columnPath != null : !this$columnPath.equals(other$columnPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DiffContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $columnPath = this.getColumnPath();
            result = result * 59 + ($columnPath == null ? 43 : $columnPath.hashCode());
            return result;
        }

        public String toString() {
            return "ParamComparator.DiffContext(columnPath=" + this.getColumnPath() + ")";
        }
    }

    public static class DiffItem {
        private int paramIdx;
        private String columnPath;

        public DiffItem(int paramIdx, DiffContext diffContext) {
            this.paramIdx = paramIdx;
            this.columnPath = diffContext.getColumnPath();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DiffItem)) {
                return false;
            }
            DiffItem diffItem = (DiffItem)o;
            return this.paramIdx == diffItem.paramIdx && Objects.equals(this.columnPath, diffItem.columnPath);
        }

        public int hashCode() {
            return Objects.hash(this.paramIdx, this.columnPath);
        }

        public int getParamIdx() {
            return this.paramIdx;
        }

        public String getColumnPath() {
            return this.columnPath;
        }

        public void setParamIdx(int paramIdx) {
            this.paramIdx = paramIdx;
        }

        public void setColumnPath(String columnPath) {
            this.columnPath = columnPath;
        }

        public String toString() {
            return "ParamComparator.DiffItem(paramIdx=" + this.getParamIdx() + ", columnPath=" + this.getColumnPath() + ")";
        }
    }

    public static class CompareResult {
        private boolean equal;
        private Set<DiffItem> diffItems;

        public CompareResult(Set<DiffItem> diffItems) {
            this.equal = CollectionUtils.isEmpty(diffItems);
            this.diffItems = diffItems;
        }

        public String toString() {
            return "{equal=" + this.equal + ", diffItems=" + this.diffItems + '}';
        }

        public boolean isEqual() {
            return this.equal;
        }

        public Set<DiffItem> getDiffItems() {
            return this.diffItems;
        }

        public void setEqual(boolean equal) {
            this.equal = equal;
        }

        public void setDiffItems(Set<DiffItem> diffItems) {
            this.diffItems = diffItems;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompareResult)) {
                return false;
            }
            CompareResult other = (CompareResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEqual() != other.isEqual()) {
                return false;
            }
            Set<DiffItem> this$diffItems = this.getDiffItems();
            Set<DiffItem> other$diffItems = other.getDiffItems();
            return !(this$diffItems == null ? other$diffItems != null : !((Object)this$diffItems).equals(other$diffItems));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CompareResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEqual() ? 79 : 97);
            Set<DiffItem> $diffItems = this.getDiffItems();
            result = result * 59 + ($diffItems == null ? 43 : ((Object)$diffItems).hashCode());
            return result;
        }

        public CompareResult() {
        }
    }
}

