/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.HeaderGroup;
import org.apache.http.params.HttpParams;

public class ReplayCloseableHttpResponse
implements CloseableHttpResponse {
    private final byte[] responseBody;
    private final HeaderGroup responseHeaderGroup;
    private final StatusLine statusLine;

    public ReplayCloseableHttpResponse(byte[] responseBody, Map<String, List<String>> headers, StatusLine statusLine) {
        this.responseBody = responseBody;
        this.statusLine = statusLine;
        this.responseHeaderGroup = new HeaderGroup();
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (Map.Entry<String, List<String>> h : headers.entrySet()) {
            for (String v : h.getValue()) {
                this.responseHeaderGroup.addHeader((Header)new BasicHeader(h.getKey(), v));
            }
        }
    }

    public HttpEntity getEntity() {
        Header contentEncodingHeader;
        if (this.responseBody == null) {
            return new BasicHttpEntity();
        }
        ByteArrayEntity entity = new ByteArrayEntity(this.responseBody);
        Header contentTypeHeader = this.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = this.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HeaderIterator headerIterator() {
        return this.responseHeaderGroup.iterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.responseHeaderGroup.iterator(name);
    }

    public boolean containsHeader(String name) {
        return this.responseHeaderGroup.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.responseHeaderGroup.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.responseHeaderGroup.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.responseHeaderGroup.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.responseHeaderGroup.getAllHeaders();
    }

    public HttpParams getParams() {
        return null;
    }

    public Locale getLocale() {
        return Locale.CHINA;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setLocale(Locale loc) {
    }

    public void addHeader(Header header) {
    }

    public void addHeader(String name, String value) {
    }

    public void setHeader(Header header) {
    }

    public void setHeader(String name, String value) {
    }

    public void setHeaders(Header[] headers) {
    }

    public void removeHeader(Header header) {
    }

    public void removeHeaders(String name) {
    }

    public void close() throws IOException {
    }

    public void setStatusLine(StatusLine statusline) {
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
    }

    public void setStatusCode(int code) throws IllegalStateException {
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
    }

    public void setEntity(HttpEntity entity) {
    }

    public void setParams(HttpParams params) {
    }
}

