/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.core.rpc.RpcContext;
import cn.com.duibaboot.ext.autoconfigure.httpclient.DuibaRestTemplateCustomizer;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientAopPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientCloseMethodInterceptor;
import cn.com.duibaboot.ext.autoconfigure.httpclient.HttpClientHystrixMethodInterceptor;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.SsreBeanPostProcessor;
import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={HttpClient.class})
@AutoConfigureBefore(name={"org.springframework.cloud.netflix.feign.ribbon.FeignRibbonClientAutoConfiguration"})
public class HttpClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientAutoConfiguration.class);

    @Primary
    @Bean(name={"httpClient"}, destroyMethod="close")
    public CloseableHttpClient httpClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setMaxConnTotal(5000).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableAutomaticRetries().disableCookieManagement().useSystemProperties().setKeepAliveStrategy(this.getKeepAliveStrategy()).setRequestExecutor(new HttpRequestExecutor(){

            public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
                if (RpcContext.hasContext() && conn instanceof HttpInetConnection) {
                    HttpInetConnection c = (HttpInetConnection)conn;
                    if (RpcContext.hasContext()) {
                        RpcContext rc = RpcContext.getContext();
                        rc.setLocalAddr(c.getLocalAddress().getHostAddress() + ":" + c.getLocalPort());
                        rc.setRemoteAddr(c.getRemoteAddress().getHostAddress() + ":" + c.getRemotePort());
                        if (logger.isDebugEnabled() && rc.getMethod() != null) {
                            logger.debug("invoking {}.{}, {} -> {}", new Object[]{rc.getMethod().getDeclaringClass().getSimpleName(), rc.getMethod().getName(), rc.getLocalAddr(), rc.getRemoteAddr()});
                        }
                    }
                }
                return super.execute(request, conn, context);
            }
        }).evictExpiredConnections().build();
    }

    @Bean
    public HttpClientHystrixMethodInterceptor httpClientHystrixMethodInterceptor() {
        return new HttpClientHystrixMethodInterceptor();
    }

    @Bean
    public HttpClientCloseMethodInterceptor httpClientCloseMethodInterceptor() {
        return new HttpClientCloseMethodInterceptor();
    }

    @Bean
    public static SpecifiedBeanPostProcessor httpClientAopPostProcessor() {
        return new HttpClientAopPostProcessor();
    }

    @Bean
    public RestTemplateCustomizer duibaRestTemplateCustomizer() {
        return new DuibaRestTemplateCustomizer();
    }

    @Bean
    @ConditionalOnProperty(name={"duiba.security.ssre.enable"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean
    public static SsreBeanPostProcessor ssreBeanFactoryPostProcessor() {
        return new SsreBeanPostProcessor();
    }

    @Bean(name={"httpAsyncClient"}, destroyMethod="close", initMethod="start")
    @Lazy
    @ConditionalOnMissingBean(name={"httpAsyncClient"})
    public CloseableHttpAsyncClient httpAsyncClient() {
        return HttpAsyncClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setRedirectsEnabled(false).setConnectTimeout(5000).setSocketTimeout(60000).setConnectionRequestTimeout(10).build()).setMaxConnPerRoute(100).setMaxConnTotal(5000).setUserAgent("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36").disableCookieManagement().useSystemProperties().setKeepAliveStrategy(this.getKeepAliveStrategy()).build();
    }

    private ConnectionKeepAliveStrategy getKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        };
    }
}

