/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.limiter;

import cn.com.duibaboot.ext.autoconfigure.limiter.ServerLimiterAutoConfiguration;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.concurrency.limits.Limiter;
import feign.Feign;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class DubboLimiterFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Method method;
        Class interfaceInstance = invoker.getInterface();
        try {
            method = interfaceInstance.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return invoker.invoke(invocation);
        }
        String serverKey = Feign.configKey((Class)interfaceInstance, (Method)method);
        Object limiter = ServerLimiterAutoConfiguration.getServerLimitRule(serverKey);
        if (limiter == null) {
            return invoker.invoke(invocation);
        }
        RpcException rateLimiterException = new RpcException(7, "\u9650\u6d41\u5f02\u5e38");
        if (limiter instanceof RateLimiter) {
            RateLimiter rateLimiter = (RateLimiter)limiter;
            if (!rateLimiter.tryAcquire()) {
                throw rateLimiterException;
            }
            return invoker.invoke(invocation);
        }
        Limiter vegasLimiter = (Limiter)limiter;
        Limiter.Listener listener = (Limiter.Listener)vegasLimiter.acquire(null).orElseThrow(() -> rateLimiterException);
        Result result = invoker.invoke(invocation);
        if (result.hasException()) {
            listener.onIgnore();
        } else {
            listener.onSuccess();
        }
        return result;
    }
}

