/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security;

import cn.com.duibaboot.ext.autoconfigure.core.utils.SpringBootUtils;
import cn.com.duibaboot.ext.autoconfigure.security.BaseSecurityManager;
import cn.com.duibaboot.ext.autoconfigure.security.SecurityProperties;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import java.sql.SQLPermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.LoggingPermission;
import javax.annotation.PostConstruct;
import javax.security.auth.AuthPermission;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Configuration
@ConditionalOnProperty(name={"duiba.securitymanager.enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={SecurityProperties.class})
public class SecurityManagerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SecurityManagerAutoConfiguration.class);
    public static final int ORDER_OF_CONTEXT_REFRESHED_EVENT = -10;
    static Set<String> forbiddenPermNames = new HashSet<String>(10);
    @Autowired
    private SecurityProperties securityProperties;
    private Set<String> whiteShells = new HashSet<String>();

    @PostConstruct
    public void init() {
        this.whiteShells.addAll(Arrays.asList("/usr/bin/id", "/bin/id", "id", "/usr/xpg4/bin/id", "setsid", "jstat", "jmap"));
        String[] forbiddenShells = new String[]{"sh", "bash", "source", "exec", "fork"};
        String str = this.securityProperties.getWhiteShellList();
        String[] arr = StringUtils.split((String)str, (char)',');
        if (arr == null) {
            return;
        }
        for (String shell : arr) {
            if (this.isForbiddenShell(shell, forbiddenShells)) {
                logger.warn("\u4f60\u8bbe\u7f6e\u7684shell\u767d\u540d\u5355(duiba.securitymanager.whiteShellList)\u4e2d\u5305\u542b\u8fc7\u4e8e\u5371\u9669\u7684shell\uff1a`{}`, \u5df2\u6392\u9664.", (Object)shell);
                continue;
            }
            this.whiteShells.add(shell);
        }
    }

    private boolean isForbiddenShell(String shell, String[] forbiddenShells) {
        for (String forbiddenShell : forbiddenShells) {
            if (!forbiddenShell.equalsIgnoreCase(shell)) continue;
            return true;
        }
        return false;
    }

    private static boolean conditionalOnMissingClass(String ... classNames) {
        boolean existsOne = false;
        for (String className : classNames) {
            try {
                Class.forName(className);
                existsOne = true;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return !existsOne;
    }

    @Bean
    public DuibaSecurityManagerConfiguarApplicationListener duibaSecurityManagerConfiguarApplicationListener() {
        return new DuibaSecurityManagerConfiguarApplicationListener();
    }

    static {
        forbiddenPermNames.add("queuePrintJob");
        if (!SpringBootUtils.isUnitTestMode()) {
            forbiddenPermNames.add("setIO");
            forbiddenPermNames.add("setSecurityManager");
        }
    }

    private class CustomSecurityManager
    extends BaseSecurityManager {
        private CircularityLock lock = new CircularityLock.Default();

        private CustomSecurityManager() {
        }

        private boolean isInWhiteShellList(String cmd) {
            return SecurityManagerAutoConfiguration.this.whiteShells.contains(cmd);
        }

        @Override
        public void checkExec(String cmd) {
            if (this.isInWhiteShellList(cmd)) {
                return;
            }
            try {
                super.checkExec(cmd);
            }
            catch (AccessControlException e) {
                logger.warn("some one try to execute shell:`{}`, block it", (Object)cmd);
                throw e;
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            if (this.lock.acquire()) {
                try {
                    this.checkPermissionInner(perm);
                }
                finally {
                    this.lock.release();
                }
            }
        }

        private void checkPermissionInner(Permission perm) {
            FilePermission fp;
            if (perm.getName().equals("getClassLoader") || perm.getName().equals("getProtectionDomain") || perm.getName().equals("accessDeclaredMembers") || perm.getName().equals("<all permissions>") || perm.getClass().getName().equals("java.lang.RuntimePermission")) {
                return;
            }
            if (perm.getClass().getName().equals("java.io.FilePermission") && (fp = (FilePermission)perm).getActions().equals("execute")) {
                super.checkPermission(perm);
                return;
            }
            if (perm instanceof AllPermission || perm instanceof PropertyPermission || perm instanceof SerializablePermission || perm instanceof ReflectPermission || perm instanceof NetPermission || perm instanceof SQLPermission || perm instanceof SecurityPermission || perm instanceof LoggingPermission || perm instanceof AuthPermission || perm instanceof SocketPermission) {
                return;
            }
            if (forbiddenPermNames.contains(perm.getName())) {
                super.checkPermission(perm);
                return;
            }
        }

        @Override
        public void checkConnect(String host, int port) {
        }

        @Override
        public void checkConnect(String host, int port, Object context) {
        }
    }

    class DuibaSecurityManagerConfiguarApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private boolean flag = true;

        DuibaSecurityManagerConfiguarApplicationListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            String os = StringUtils.defaultString((String)System.getProperty("os.name"));
            if (os.toLowerCase().contains("windows")) {
                return;
            }
            if (!this.flag) {
                return;
            }
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new CustomSecurityManager());
            }
            this.flag = false;
        }

        public int getOrder() {
            return -10;
        }
    }

    static interface CircularityLock {
        public boolean acquire();

        public void release();

        public static class Global
        implements CircularityLock {
            private final Lock lock = new ReentrantLock();
            private final long time;
            private final TimeUnit timeUnit;

            public Global() {
                this(0L, TimeUnit.MILLISECONDS);
            }

            public Global(long time, TimeUnit timeUnit) {
                this.time = time;
                this.timeUnit = timeUnit;
            }

            @Override
            public boolean acquire() {
                try {
                    return this.time == 0L ? this.lock.tryLock() : this.lock.tryLock(this.time, this.timeUnit);
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }

            @Override
            public void release() {
                this.lock.unlock();
            }
        }

        public static class Default
        extends ThreadLocal<Boolean>
        implements CircularityLock {
            private static final Boolean NOT_ACQUIRED = null;

            @Override
            public boolean acquire() {
                if (this.get() == NOT_ACQUIRED) {
                    this.set(true);
                    return true;
                }
                return false;
            }

            @Override
            public void release() {
                this.set(NOT_ACQUIRED);
            }
        }

        public static enum Inactive implements CircularityLock
        {
            INSTANCE;


            @Override
            public boolean acquire() {
                return true;
            }

            @Override
            public void release() {
            }
        }
    }
}

