/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceCallable;

public class MonitorCallable
implements Callable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorCallable.class);
    private static final boolean IS_SLEUTH_CLASS_EXISTS;
    private Callable callable;
    private BlockingQueue<Runnable> queue;
    private final int maxWaitTimeMillis;
    private final long submitTimeMillis;

    public MonitorCallable(Callable callable) {
        this(callable, null);
    }

    public MonitorCallable(Callable callable, BlockingQueue<Runnable> queue) {
        this(callable, queue, 1000);
    }

    public MonitorCallable(Callable callable, BlockingQueue<Runnable> queue, int maxWaitTimeMillis) {
        this.callable = callable;
        this.queue = queue;
        this.submitTimeMillis = System.currentTimeMillis();
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    public long getSubmitTimeMillis() {
        return this.submitTimeMillis;
    }

    public Callable getCallable() {
        return this.callable;
    }

    public Object call() throws Exception {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= (long)this.maxWaitTimeMillis) {
            if (this.queue == null) {
                logger.warn("CallableClass:{},ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{this.getRootCallable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.warn("CallableClass:{},ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{this.getRootCallable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        return this.callable.call();
    }

    protected Callable getRootCallable() {
        Callable rootCallable = this.getCallable();
        if (IS_SLEUTH_CLASS_EXISTS && rootCallable instanceof SpanContinuingTraceCallable) {
            rootCallable = ((SpanContinuingTraceCallable)rootCallable).getDelegate();
        }
        return rootCallable;
    }

    static {
        boolean isSleuthClassExists = false;
        try {
            Class.forName("org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable");
            isSleuthClassExists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SLEUTH_CLASS_EXISTS = isSleuthClassExists;
    }
}

